/* ------------------------------------------------------------------------ */
/*  Hyper Operating System V4  ITRON4.0 Real-Time OS                  */
/*    ITRONͥ ǽ                                          */
/*                                                                          */
/*                                  Copyright (C) 1998-2006 by Project HOS  */
/*                                  http://sourceforge.jp/projects/hos/     */
/* ------------------------------------------------------------------------ */


#include "knl_tsk.h"
#include "knl_sys.h"
#include "knl_mem.h"


static void kernel_exd_tsk(VP_INT exinf);	/* νλȺ(ƥॿǼ¹) */


/* νλȺ */
void exd_tsk(void)
{
	T_KERNEL_TCB_RAM *tcb_ram;
	T_MKNL_TCB       *mtcb_run;

	/* ¹楿μ */
	mtcb_run = mknl_get_run_tsk();
	tcb_ram  = KERNEL_STATIC_CAST(T_KERNEL_TCB_RAM, mtcb, mtcb_run);

	mknl_loc_sys();		/* ƥΥå */

	/* ƥॿԤ */
	mknl_exe_sys((FP)kernel_exd_tsk, (VP_INT)tcb_ram);
}


/* νλȺ(ƥॿǼ¹) */
void kernel_exd_tsk(VP_INT exinf)
{
	T_KERNEL_TCB_RAM *tcb_ram;
	ID               tskid;
	
	tcb_ram = (T_KERNEL_TCB_RAM *)exinf;
	tskid   = kernel_get_tid(tcb_ram);

	/* λ */
	mknl_ter_tsk(&tcb_ram->mtcb);
	
	/* β */
	kernel_fre_mem(tcb_ram);
	
	/* ȥ֥åơ֥뤫Ͽ */
	KERNEL_TSKID_TO_TCB_RAM(tskid) = NULL;

	/* ǥѥåμ¹ */
	mknl_exe_dsp();
}


/* ------------------------------------------------------------------------ */
/*  Copyright (C) 1998-2006 by Project HOS                                  */
/* ------------------------------------------------------------------------ */
