/* ------------------------------------------------------------------------ */
/*  Hyper Operating System V4  ITRON4.0 Real-Time OS                  */
/*    ץåݲݡͥ (MIPS3ߴ)                      */
/*    ߥϥɥ                                                      */
/*                                                                          */
/*                                  Copyright (C) 1998-2008 by Project HOS  */
/*                                  http://sourceforge.jp/projects/hos/     */
/* ------------------------------------------------------------------------ */
#include "mipsregs.h"
#include "mips/vect.h"

		.global int_handler				# ߥϥɥ
		.global inthdl					# crt0.c 
		.global einthdl					# crt0.c 
		.global inthdljp				# crt0.c 
# **************************************************************************
# *  ߥϥɥ (0x80000800  crt0.c ˤƥԡ
# *  ǳװȽꤷϿϥɥƤӽФ
# *  ߤϥ޳ߤݡȤƤʤ
# **************************************************************************

		.text
		.align	4
int_handler:
inthdl:
		pushall							# 쥸

		# ¿ųߤȽ
		la		t8, kernel_int_cnt
		lw		t9, (t8)
		beql	t9, $0, _int_l01
		nop
		addiu	t9, t9, 1
		sw		t9, (t8)
		beql	$0, $0, _int_l02
		nop
_int_l01:
		addiu	t9, t9, 1
		sw		t9, (t8)
		# å
		la		t8, kernel_int_ssp
		sw		sp, (t8)
		la		t8, kernel_int_sp
		lw		sp, (t8)
		# ߳ϽƤӽФ
		la		t8, kernel_sta_int
		jal		t8
		nop
#
#	㳰Ƥγǧʬ
#
_int_l02:
		.set noreorder
		mfc0	t8, CP0_CAUSE
		mfc0	t9, CP0_STATUS
		nop
		nop
		and		t8, t8, t9
#		sw		t8, kernel_int_reg_t8	# γߤΤ¸
	#
	#	IP7 : CP0 INT7 (㳰 HOSΥڤؤ)
	#
_irq_ip7:
		andi	t9, t8, (1 << 15)
		beq		t9, $0, _irq_ip2
		nop
		# ֹƼ¹ԽƤӽФ
		la		t8, kernel_exe_int
		li		a0, HOS_VN_IP7			# ߥ٥ֹ
		jal		t8
		nop
		beql	$0, $0, _ret_from_irq
		nop
	#
	#	IP2 : External INT2 (㳰 )
	#
_irq_ip2:
#		lw		t8, kernel_int_reg_t8
		andi	t9, t8, (1 << 10)
		beq		t9, $0, _irq_ip1
		nop
		# ֹƼ¹ԽƤӽФ
		la		t8, kernel_exe_int
		li		a0, HOS_VN_IP2
		jal		t8
		nop
		beql	$0, $0, _ret_from_irq
		nop
	#
	# IP1 : Software INT1 (㳰 եȥߣ)
	#
_irq_ip1:
#		lw		t8, kernel_int_reg_t8
		andi	t9, t8, (1 <<  9)
		beq		t9, $0, _irq_ip0
		nop
		# ֹƼ¹ԽƤӽФ
		la		t8, kernel_exe_int
		li		a0, HOS_VN_IP1
		jal		t8
		nop
		beql	$0, $0, _ret_from_irq
		nop
	#
	# IP0 : Software INT0 (㳰 եȥߣ)
	#
_irq_ip0:
#		lw		t8, kernel_int_reg_t8
		andi	t9, t8, (1 << 8)
		beq		t9, $0, _exccode
		nop
		# ֹƼ¹ԽƤӽФ
		la		t8, kernel_exe_int
		li		a0, HOS_VN_IP0
		jal		t8
		nop
		beql	$0, $0, _ret_from_irq
		nop
	#
	# ExcCode ν
	#
_exccode:
#		lw		t8, kernel_int_reg_t8
		srl		t8, t8, 2
		andi	t8, t8, 0x001F			# ExcCode Τ߼Ф
#		sw		t8, kernel_int_reg_t8
	#
	# ExcCode 1 Mod (㳰 TLBѹ㳰)
	#
_exccode_1:
		slti	t9, t8, 1
		bnez	t9, _exccode_2
		nop
		# ֹƼ¹ԽƤӽФ
		la		t8, kernel_exe_int
		li		a0, HOS_VN_ExcCode1
		jal		t8
		nop
		beql	$0, $0, _ret_from_irq
		nop
	#
	# ExcCode 2 TLBL (㳰 TLB԰㳰 ɤޤ̿եå)
	#
_exccode_2:
#		lw		t8, kernel_int_reg_t8
		slti	t9, t8, 2
		bnez	t9, _exccode_3
		nop
		# ֹƼ¹ԽƤӽФ
		la		t8, kernel_exe_int
		li		a0, HOS_VN_ExcCode2
		jal		t8
		nop
		beql	$0, $0, _ret_from_irq
		nop
	#
	# ExcCode 3 TLBS (㳰 TLB԰㳰 ȥ
	#
_exccode_3:
#		lw		t8, kernel_int_reg_t8
		slti	t9, t8, 3
		bnez	t9, _exccode_4
		nop
		# ֹƼ¹ԽƤӽФ
		la		t8, kernel_exe_int
		li		a0, HOS_VN_ExcCode3
		jal		t8
		nop
		beql	$0, $0, _ret_from_irq
		nop
	#
	# ExcCode 4 AdEL (㳰 ɥ쥹顼㳰 ɤޤ̿եå
	#
_exccode_4:
#		lw		t8, kernel_int_reg_t8
		slti	t9, t8, 4
		bnez	t9, _exccode_5
		nop
		# ֹƼ¹ԽƤӽФ
		la		t8, kernel_exe_int
		li		a0, HOS_VN_ExcCode4
		jal		t8
		nop
		beql	$0, $0, _ret_from_irq
		nop
	#
	# ExcCode 5 AdES (㳰 ɥ쥹顼㳰 ȥ
	#
_exccode_5:
#		lw		t8, kernel_int_reg_t8
		slti	t9, t8, 5
		bnez	t9, _exccode_6
		nop
		# ֹƼ¹ԽƤӽФ
		la		t8, kernel_exe_int
		li		a0, HOS_VN_ExcCode5
		jal		t8
		nop
		beql	$0, $0, _ret_from_irq
		nop
	#
	# ExcCode 6 IBE (㳰 Х顼㳰 ̿եå
	#
_exccode_6:
	#	lw		t8, kernel_int_reg_t8
	#	slti	t9, t8, 6
	#	bnez	t9, _exccode_6
	#	nop
	#	# ֹƼ¹ԽƤӽФ
	#	la		t8, kernel_exe_int
	#	li		a0, HOS_VN_ExcCode6
	#	jal		t8
	#	nop
	#
	# ExcCode 7 DBE (㳰 Х顼㳰 ǡΥɤޤϥȥ
	#
_exccode_7:
	#	lw		t8, kernel_int_reg_t8
	#	slti	t9, t8, 7
	#	bnez	t9, _exccode_8
	#	nop
	#	# ֹƼ¹ԽƤӽФ
	#	la		t8, kernel_exe_int
	#	li		a0, HOS_VN_ExcCode7
	#	jal		t8
	#	nop
	#
	# ExcCode 8 Sys (㳰 ƥࡦ㳰)
	#
_exccode_8:
#		lw		t8, kernel_int_reg_t8
		slti	t9, t8, 8
		bnez	t9, _exccode_9
		nop
		# ֹƼ¹ԽƤӽФ
		la		t8, kernel_exe_int
		li		a0, HOS_VN_ExcCode8
		jal		t8
		nop
		beql	$0, $0, _ret_from_irq
		nop
	#
	# ExcCode 9 Bp (㳰 ֥졼ݥ㳰)
	#
_exccode_9:
#		lw		t8, kernel_int_reg_t8
		slti	t9, t8, 9
		bnez	t9, _exccode_10
		nop
		# ֹƼ¹ԽƤӽФ
		la		t8, kernel_exe_int
		li		a0, HOS_VN_ExcCode9
		jal		t8
		nop
		beql	$0, $0, _ret_from_irq
		nop
	#
	# ExcCode 10 RI (㳰 ͽ̿㳰)
	#
_exccode_10:
#		lw		t8, kernel_int_reg_t8
		slti	t9, t8, 10
		bnez	t9, _exccode_11
		nop
		# ֹƼ¹ԽƤӽФ
		la		t8, kernel_exe_int
		li		a0, HOS_VN_ExcCode10
		jal		t8
		nop
		beql	$0, $0, _ret_from_irq
		nop
	#
	# ExcCode 11 CpU (㳰 ץåԲ㳰)
	#
_exccode_11:
#		lw		t8, kernel_int_reg_t8
		slti	t9, t8, 11
		bnez	t9, _exccode_12
		nop
		# ֹƼ¹ԽƤӽФ
		la		t8, kernel_exe_int
		li		a0, HOS_VN_ExcCode11
		jal		t8
		nop
		beql	$0, $0, _ret_from_irq
		nop
	#
	# ExcCode 12 Ov (㳰 黻Хե㳰)
	#
_exccode_12:
#		lw		t8, kernel_int_reg_t8
		slti	t9, t8, 12
		bnez	t9, _exccode_13
		nop
		# ֹƼ¹ԽƤӽФ
		la		t8, kernel_exe_int
		li		a0, HOS_VN_ExcCode12
		jal		t8
		nop
		beql	$0, $0, _ret_from_irq
		nop
	#
	# ExcCode 13 Tr (㳰 ȥå㳰)
	#
_exccode_13:
#		lw		t8, kernel_int_reg_t8
		slti	t9, t8, 13
		bnez	t9, _exccode_15
		nop
		# ֹƼ¹ԽƤӽФ
		la		t8, kernel_exe_int
		li		a0, HOS_VN_ExcCode13
		jal		t8
		nop
		beql	$0, $0, _ret_from_irq
		nop
	#
	# ExcCode 15 FPE (㳰 ư㳰)
	#
_exccode_15:
#		lw		t8, kernel_int_reg_t8
		slti	t9, t8, 15
		bnez	t9, _exccode_23
		nop
		# ֹƼ¹ԽƤӽФ
		la		t8, kernel_exe_int
		li		a0, HOS_VN_ExcCode15
		jal		t8
		nop
		beql	$0, $0, _ret_from_irq
		nop
	#
	# ExcCode 23 Watch (㳰 å㳰)
	#
_exccode_23:
#		lw		t8, kernel_int_reg_t8
		slti	t9, t8, 23
		bnez	t9, _ret_from_irq
		nop
		# ֹƼ¹ԽƤӽФ
		la		t8, kernel_exe_int
		li		a0, HOS_VN_ExcCode23
		jal		t8
		nop
		.set	reorder
	#
	# 쥸 eret
	#
_ret_from_irq:
		la		t8, kernel_int_cnt
		lw		t9, (t8)
		addiu	t9, t9, -1
		sw		t9, (t8)
		bne		t9, $0, _int_l12
		nop

_int_l11:
		# å
		la		t8, kernel_int_ssp
		lw		sp, (t8)
		# IE=0, EXL=0˥åȡʳߤ϶ػߤΤޤ)
		mfc0	t8, CP0_STATUS
		nop
		la		t9, 0xF1FFFFF8			# ERL=0,IE=0,EXL=0
		and		t8, t9, t8
		mtc0	t8, CP0_STATUS
		nop
		# ߽λƤӽФ
		la		t8, kernel_end_int
		jal		t8
		nop
		# IE=1, EXL=1˥åȡʳߤ϶ػߤΤޤ)
		mfc0	t8, CP0_STATUS
		nop
		la		t9, 0xF1FFFFFB
		and		t8, t9, t8				# ERL=0
		la		t9, 0x00000003			# IE=1, EXL=1
		or		t8, t9, t8
		mtc0	t8, CP0_STATUS
		nop
_int_l12:
		popall							# 쥸
		eret
einthdl:
# **************************************************************************
# *  0x80000180㳰ȯinthdlؽܹԤ뤿κٹ
# *  crt0.c ˤƥ̿򥳥ԡ¸롣
# **************************************************************************
		.text
		.align	4
inthdljp:								# 0x80000180 إԡ(crt0.cˤ)
		j		0x80000800
		nop
# **************************************************************************
# *  㳰ȯ CP0_STATUS & CP0_CAUSE ¸뤿ѿ
# **************************************************************************
		.data
		.align	4
kernel_int_reg_t8:
		nop
/* ------------------------------------------------------------------------ */
/*  Copyright (C) 1998-2008 by Project HOS                                  */
/* ------------------------------------------------------------------------ */
