/* ------------------------------------------------------------------------ */
/*  Hyper Operating System V4  ITRON4.0 Real-Time OS                  */
/*    ̥ͥ                                                  */
/*                                                                          */
/*                                  Copyright (C) 1998-2002 by Project HOS  */
/*                                  http://sourceforge.jp/projects/hos/     */
/* ------------------------------------------------------------------------ */


#include "mknl.h"



/* γ */
void mknl_sta_tsk(
		T_MKNL_TCB *mtcb,					/* ̥ͥ륿ȥ֥å */
		VP_INT     exinf,					/* γĥ */
		FP         task,					/* εư */
		PRI        tskpri,					/* εưͥ */
		SIZE       stksz,					/* ΥåΰΥ */
		VP         stk)						/* ΥåΰƬ */
{
	/* ¹ԥƥȤκ */
	mtcb->data = exinf;
	hospac_cre_ctx(&mtcb->ctxinf, exinf, task, stksz, stk);

	/* ξ */
	mtcb->tskstat = TTS_RDY;	/* ǥ֤ */
	mtcb->texstat = 0;			/* 㳰ֽ */
	mtcb->tskpri  = tskpri;		/* ͥ */
	mtcb->tskwait = 0;			/* Ԥװ */

	/* ǥ塼 */
	mknl_adf_que(&mknl_rdq_tbl[tskpri - TMIN_TPRI], mtcb);
}


/* ------------------------------------------------------------------------ */
/*  Copyright (C) 1998-2002 by Project HOS                                  */
/* ------------------------------------------------------------------------ */
