/** 
 *  Hyper Operating System  Application Framework
 *
 * @file  fatmount_main.c
 * @brief %jp{FATܥ塼 ޥȥޥ}
 *
 * Copyright (C) 2006-2008 by Project HOS
 * http://sourceforge.jp/projects/hos/
 */



#include "hosaplfw.h"
#include "fatmount.h"
#include "driver/volume/fat/fatvol.h"



/* FATܥ塼 ޥȥޥ */
int FatMount_Main(int argc, char *argv[])
{
	HANDLE	hVolume;
	char	*pszMountName = NULL;
	char	*pszDevName   = NULL;
	int		iUnmount = 0;
	int		i;
		
	/* ץ */
	for ( i = 1; i < argc; i++ )
	{
		if ( argv[i][0] == '-' )
		{
			if ( argv[i][1] == 'u' && argv[i][2] == '\0' )
			{
				iUnmount = 1;
			}
		}
		else
		{
			if ( pszMountName == NULL )
			{
				pszMountName = argv[i];
			}
			else if ( pszDevName == NULL )
			{
				pszDevName = argv[i];
			}
		}
	}
	
	/* ƥ⡼ɰܹ */
	if ( Process_EnterSystemMode() != PROCESS_ERR_OK )
	{
		return 1;	/* ƥย̵ */
	}
	
	if ( !iUnmount )	/* FATܥ塼ޥ */
	{
		/* ѥ᡼å */
		if ( pszMountName == NULL || pszDevName == NULL )
		{
			Process_LeaveSystemMode();
			return 1;
		}
		
		/* FATܥ塼 */
		hVolume = FatVol_Create(pszDevName);
		if ( hVolume == HANDLE_NULL )
		{
			StdIo_PrintFormat("device open error\n");
			Process_LeaveSystemMode();
			return 1;
		}
		
		/* ƥϿ */
		File_AddVolume(pszMountName, hVolume);		
	}
	else	/* FATܥ塼ॢޥ */
	{
		if ( pszMountName == NULL )
		{
			Process_LeaveSystemMode();
			return 1;
		}
		
		/* ǥХ */
		hVolume = File_GetVolume(pszMountName);
		if ( hVolume ==  HANDLE_NULL )
		{
			Process_LeaveSystemMode();
			return 1;
		}
		
		/* åȥ */
		if ( Volume_Shutdown(hVolume) != FILE_ERR_OK )
		{
			StdIo_PrintFormat("shutdown failed\n");
			Process_LeaveSystemMode();
			return 1;
		}
		
		/* ƥफ곰 */
		File_RemoveVolume(pszMountName);
		
		/* ܥ塼 */
		FatVol_Delete(hVolume);
	}
	
	/* ƥ⡼ɤȴ */
	Process_LeaveSystemMode();
	
	return 0;
}


/* end of file */
