/** 
 * Hyper Operating System  Application Framework
 *
 * @file  pcattextdrv_constructor.c
 * @brief %jp{PC/AT text mode driver ֥Ⱥ}%en{PC/AT text mode driver  delete object}
 *
 * Copyright (C) 2008 by Project HOS
 * http://sourceforge.jp/projects/hos/
 */


#include "pcattextdrv_local.h"


/** %jp{۴ؿơ֥}%en{virtual functions table} */
const T_DRVOBJ_METHODS PcatTextDrv_Methods = 
	{
		{ PcatTextDrv_Delete },
		PcatTextDrv_Open,
		PcatTextDrv_Close,
		PcatTextDrv_IoControl,
		DrvObj_Seek,
		DrvObj_Read,
		PcatTextDrv_Write,
		DrvObj_Flush,
	};


/** 󥹥ȥ饯 */
FILE_ERR PcatTextDrv_Constructor(C_PCATTEXTDRV *self, const T_DRVOBJ_METHODS *pMethods, void *pRegBase, void *pVramBase)
{
	/* ۴ؿơ֥ */
	if ( pMethods == NULL )
	{
		pMethods = &PcatTextDrv_Methods;
	}
	
	/* ƥ饹󥹥ȥ饯ƤӽФ */
	DrvObj_Constructor(&self->DrvObj, pMethods);
	
	/* ѿ */
	self->pRegBase      = pRegBase;
	self->puhTextVram   = (volatile unsigned short *)pVramBase;
	
	self->iOpenCount    = 0;

	self->iScreenWidth  = 80;
	self->iScreenHeight = 25;

	self->ubCharAttr    = 0x07;
	self->iCursorX      = 0;
	self->iCursorY      = 0;
	
	
	PcatTextDrv_ClearScreen(self);
	PcatTextDrv_SetCursor(self, 0, 0);
	
	
	return FILE_ERR_OK;
}


/* end of file */
