/** 
 *  Hyper Operating System  Application Framework
 *
 * @file  lan9000drv.h
 * @brief %jp{LAN9000եߥ꡼ѥǥХɥ饤}
 *
 * Copyright (C) 2006-2007 by Project HOS
 * http://sourceforge.jp/projects/hos/
 */


#include "lan9000drv_local.h"



/** 󥹥ȥ饯 */
FILE_ERR Lan9000Drv_Constructor(C_LAN9000DRV *self, const T_DRVOBJ_METHODS *pMethods, void *pRegBase, int iIntNum)
{
	FILE_ERR	ErrCode;

	/* ƥ饹󥹥ȥ饯ƤӽФ */
	if ( (ErrCode = SyncDrv_Constructor(&self->SyncDrv, pMethods, SYNCDRV_FACTOR_NUM)) != FILE_ERR_OK )
	{
		return ErrCode;
	}
	
	/* ѿ */
	self->iOpenCount = 0;
	
	/* Lan9000Hal  */
	Lan9000Hal_Create(&self->Lan9000Hal, pRegBase);

	/* ߥ塼ƥå */
	self->hMtx = SysMtx_Create(SYSMTX_ATTR_NORMAL);

	/* ߽Ͽ */
	self->iIntNum = iIntNum;
	self->hIsr = SysIsr_Create(iIntNum, Lan9000Drv_Isr, (VPARAM)self);
	
	return FILE_ERR_OK;
}


/* end of file */
