/** 
 *  Hyper Operating System  Application Framework
 *
 * @file  scidrv.c
 * @brief %jp{LAN9000ѥǥХɥ饤}
 *
 * Copyright (C) 2006 by Project HOS
 * http://sourceforge.jp/projects/hos/
 */


#include "lan9000drv_local.h"


/*  */
void Lan9000Drv_Isr(VPARAM Param)
{
	C_LAN9000DRV	*self;
	unsigned short	uhStatus;

	self = (C_LAN9000DRV *)Param;
	
	/* ּ */
	uhStatus = Lan9000Hal_GetInterruptStatus(&self->Lan9000Hal);
	
	/* Ƥ */
	if ( uhStatus & LAN9000HAL_ISTATUS_RCVINT )
	{
		/* ɹߥʥȯ */
		SyncDrv_SendSignal(&self->SyncDrv, SYNCDRV_FACTOR_READ);
		uhStatus &= ~LAN9000HAL_IMASK_RCVINT;
	}

	/* ǽʤ */
	if ( uhStatus & LAN9000HAL_ISTATUS_ALLOCINT )
	{
		/* ߥʥȯ */
		SyncDrv_SendSignal(&self->SyncDrv, SYNCDRV_FACTOR_WRITE);
		uhStatus &= ~LAN9000HAL_IMASK_ALLOCINT;
	}
	
	/* ߥޥ */
	Lan9000Hal_SetInterruptMask(&self->Lan9000Hal, uhStatus);	
	
	/* ߥꥢ */
	SysInt_Clear(self->iIntNum);
}


/* end of file */
