/** 
 *  Hyper Operating System  Application Framework
 *
 * @file  scidrv.c
 * @brief %jp{LAN9000ѥǥХɥ饤}
 *
 * Copyright (C) 2006 by Project HOS
 * http://sourceforge.jp/projects/hos/
 */


#include "lan9000drv_local.h"


/** %jp{} */
FILE_SIZE Lan9000Drv_Read(C_DRVOBJ *pDrvObj, C_FILEOBJ *pFileObj, void *pBuf, FILE_SIZE Size)
{
	C_LAN9000DRV	*self;
	C_SYNCFILE		*pFile;
	FILE_SIZE		RecvSize;
	FILE_ERR		ErrCode;
	unsigned short	uhStatus;
		
	/* upper cast */
	self  = (C_LAN9000DRV *)pDrvObj;
	pFile = (C_SYNCFILE *)pFileObj;
	
	/* ɹ߽ */
	if ( (ErrCode = SyncDrv_StartProcess(&self->SyncDrv, pFile, SYNCDRV_FACTOR_READ)) != FILE_ERR_OK )
	{
		return (FILE_SIZE)ErrCode;
	}
	
	/* ɹߥʥöꥢ */
	SyncFile_ClearSignal(pFile, SYNCDRV_FACTOR_READ);
	
	for ( ; ; )
	{
		/*  */
		SysMtx_Lock(self->hMtx);	/* ƥ륻 */
		RecvSize = Lan9000Hal_Recv(&self->Lan9000Hal, pBuf, Size);
		SysMtx_Unlock(self->hMtx);	/* ƥ륻Ф */
		
		/* Ǥȴ */
		if ( RecvSize != 0 )
		{
			break;
		}

		/* ߤĤ */
		uhStatus = Lan9000Hal_GetInterruptStatus(&self->Lan9000Hal);
		Lan9000Hal_SetInterruptMask(&self->Lan9000Hal, (uhStatus | LAN9000HAL_IMASK_RCVINT));
		
		/* ֥å󥰥⡼ɤǤʤȴ */
		if ( SyncFile_GetSyncMode(pFile, SYNCDRV_FACTOR_READ) != FILE_SYNCMODE_BLOCKING )
		{
			SyncDrv_EndProcess(&self->SyncDrv, SYNCDRV_FACTOR_READ, 0);
			return 0;
		}
				
		/* Ԥ */
		SyncFile_WaitSignal(pFile, SYNCDRV_FACTOR_READ);
			
		/* ɹߥʥ򥯥ꥢƥȥ饤 */
		SyncFile_ClearSignal(pFile, SYNCDRV_FACTOR_READ);
	}

	/* ɤ߽Фλ */
	SyncDrv_EndProcess(&self->SyncDrv, SYNCDRV_FACTOR_READ, (VPARAM)0);
	
	return RecvSize;
}


/* end of file */
