/** 
 *  Hyper Operating System  Application Framework
 *
 * @file  lan9118drv.h
 * @brief %jp{SMSC LAN9118꡼ѥǥХɥ饤}
 *
 * Copyright (C) 2006-2007 by Project HOS
 * http://sourceforge.jp/projects/hos/
 */


#ifndef __HOS__lan9118drv_h__
#define __HOS__lan9118drv_h__


#include "system/sysapi/sysapi.h"
#include "system/file/syncdrv.h"


/* UARTɥ饤 */
typedef struct c_lan9118drv
{
	C_SYNCDRV		SyncDrv;			/* 饯ǥХɥ饤ФѾ */

	void			*pRegBase;		/* 쥸١ɥ쥹 */
	int				iIntNum;		/* ֹ */
	
	int				iOpenCount;		/* ץ󥫥 */
	
	SYSEVT_HANDLE	hEvtSend;		/* ٥ */
	SYSEVT_HANDLE	hEvtRecv;		/* ٥ */
	SYSMTX_HANDLE	hMtxSend;		/* ¾ߥ塼ƥå */
	SYSMTX_HANDLE	hMtxRecv;		/* ¾ߥ塼ƥå */
	
	unsigned char	ubMacAddr[6];	/* MACɥ쥹 */
	
} C_LAN9118DRV;



#ifdef __cplusplus
extern "C" {
#endif

void Lan9118Drv_Create(C_LAN9118DRV *self, void *pRegBase, int iIntNum);	/**< 󥹥ȥ饯 */
void Lan9118Drv_Delete(C_DRVOBJ *pDrvObj);									/**< ǥȥ饯 */

#ifdef __cplusplus
}
#endif


#endif	/* __HOS__lan9118drv_h__ */


/* end of file */
