/** 
 *  Hyper Operating System  Application Framework
 *
 * @file  ne2000drv.c
 * @brief %jp{NE2000ߴEtherѥǥХɥ饤}
 *
 * Copyright (C) 2006 by Project HOS
 * http://sourceforge.jp/projects/hos/
 */


#include "ne2000drv_local.h"



/* ۴ؿơ֥ */
const T_DRVOBJ_METHODS Ne2000Drv_Methods = 
	{
		Ne2000Drv_Delete,
		Ne2000Drv_Open,
		Ne2000Drv_Close,
		Ne2000Drv_IoControl,
		Ne2000Drv_Seek,
		Ne2000Drv_Read,
		Ne2000Drv_Write,
		Ne2000Drv_Flush,
	};


/** 󥹥ȥ饯 */
void Ne2000Drv_Create(C_NE2000DRV *self, void *pRegAddr, int iIntNum)
{
	/* ƥ饹󥹥ȥ饯ƤӽФ */
	SyncDrv_Create(&self->SyncDrv, &Ne2000Drv_Methods);

	/* ѿ */
	self->iOpenCount = 0;

	/* Ne2000Hal  */
	Ne2000Hal_Create(&self->Ne2000Hal, pRegAddr);

	/* ٥ */
	self->hEvtRecv = SysEvt_Create(SYSEVT_ATTR_AUTOCLEAR);
	self->hEvtSend = SysEvt_Create(SYSEVT_ATTR_AUTOCLEAR);

	/* ߥ塼ƥå */
	self->hMtx = SysMtx_Create(SYSMTX_ATTR_NORMAL);

	/* ߽Ͽ */
	SysIsr_Create(iIntNum, Ne2000Drv_Isr, (VPARAM)self);
}


/** ǥȥ饯 */
void Ne2000Drv_Delete(C_DRVOBJ *pDrvObj)
{
	C_NE2000DRV *self;
	
	/* upper cast */
	self = (C_NE2000DRV *)pDrvObj;

	/* ֥Ⱥ */
	SysEvt_Delete(self->hEvtRecv);
	SysEvt_Delete(self->hEvtSend);
	SysMtx_Delete(self->hMtx);
	
	/* ƥ饹ǥȥ饯 */
	SyncDrv_Delete(&self->SyncDrv);
}


/** ץ */
HANDLE Ne2000Drv_Open(C_DRVOBJ *pDrvObj, const char *pszPath, int iMode)
{
	C_NE2000DRV *self;
	C_SYNCFILE	*pFile;
	
	/* upper cast */
	self = (C_NE2000DRV *)pDrvObj;

	/* create file descriptor */
	if ( (pFile = SysMem_Alloc(sizeof(C_SYNCFILE))) == NULL )
	{
		return HANDLE_NULL;
	}
	SyncFile_Create(pFile, &self->SyncDrv, NULL);
	
	
	/* ץ */
	SysMtx_Lock(self->hMtx);
	if ( self->iOpenCount++ == 0 )
	{
		Ne2000Hal_Setup(&self->Ne2000Hal);
	}
	SysMtx_Unlock(self->hMtx);


	return (HANDLE)pFile;
}


/**  */
void Ne2000Drv_Close(C_DRVOBJ *pDrvObj, C_FILEOBJ *pFileObj)
{
	C_NE2000DRV *self;
	C_SYNCFILE	*pFile;

	/* upper cast */
	self  = (C_NE2000DRV *)pDrvObj;
	pFile = (C_SYNCFILE *)pFileObj;
	
	SysMtx_Lock(self->hMtx);
	if ( --self->iOpenCount == 0 )
	{
		Ne2000Hal_Stop(&self->Ne2000Hal);
	}
	SysMtx_Unlock(self->hMtx);


	/* ǥץ */
	SyncFile_Delete((C_SYNCFILE *)pFile);	
	SysMem_Free(pFile);
}


/** %jp{} */
FILE_SIZE Ne2000Drv_Read(C_DRVOBJ *pDrvObj, C_FILEOBJ *pFileObj, void *pBuf, FILE_SIZE Size)
{
	C_NE2000DRV 	*self;
	C_SYNCFILE		*pFile;
	unsigned char	*pubBuf;
	int				iRecvSize = 0;
	
	/* upper cast */
	self  = (C_NE2000DRV *)pDrvObj;
	pFile = (C_SYNCFILE *)pFileObj;

	/* Хåե */
	pubBuf = (unsigned char *)pBuf;

	for ( ; ; )
	{
		SysMtx_Lock(self->hMtx);
		iRecvSize = Ne2000Hal_Recv(&self->Ne2000Hal, pubBuf, Size);
		SysMtx_Unlock(self->hMtx);

		if ( iRecvSize > 0 )
		{
			break;
		}
		
		/* ֥å󥰤Ǥʤȴ */
		if ( pFile->cReadMode != FILE_RMODE_BLOCKING )
		{
			break;
		}

		/* ٥ȤԤ */
		SysEvt_Wait(self->hEvtRecv);
		SysEvt_Clear(self->hEvtRecv);
	}
	
	return iRecvSize;
}


/** %jp{} */
FILE_SIZE Ne2000Drv_Write(C_DRVOBJ *pDrvObj, C_FILEOBJ *pFileObj, const void *pData, FILE_SIZE Size)
{
	C_NE2000DRV 	*self;
	C_SYNCFILE		*pFile;
	
	/* upper cast */
	self  = (C_NE2000DRV *)pDrvObj;
	pFile = (C_SYNCFILE *)pFileObj;

	SysMtx_Lock(self->hMtx);
	Size = Ne2000Hal_Send(&self->Ne2000Hal, pData, Size);
	SysMtx_Unlock(self->hMtx);
	
	return Size;
}


/* ߽ */
void Ne2000Drv_Isr(VPARAM Param)
{
	C_NE2000DRV *self;

	self = (C_NE2000DRV *)Param;
}


/* end of file */
