/** 
 *  Hyper Operating System  Application Framework
 *
 * @file  memdrv.h
 * @brief %jp{ޥåץɥեѥǥХɥ饤}
 *
 * Copyright (C) 2006-2007 by Project HOS
 * http://sourceforge.jp/projects/hos/
 */


#include "memdrv_local.h"


/* ۴ؿơ֥ */
static const T_DRVOBJ_METHODS MemDrv_Methods = 
	{
		{ MemDrv_Delete },
		MemDrv_Open,
		MemDrv_Close,
		MemDrv_IoControl,
		MemDrv_Seek,
		MemDrv_Read,
		MemDrv_Write,
		MemDrv_Flush,
		MemDrv_GetInformation,
	};


/** 󥹥ȥ饯 */
void MemDrv_Constructor(C_MEMDRV *self, const T_DRVOBJ_METHODS *pMethods, void *pMemAddr, FILE_POS MemSize, FILE_POS IniSize, int iAttr)
{
	if ( pMethods == NULL )
	{
		pMethods = &MemDrv_Methods;
	}
	
	/* ƥ饹󥹥ȥ饯ƤӽФ */
	DrvObj_Constructor(&self->DrvObj, pMethods);
	
	/* ѿ */
	self->iOpenCount = 0;
	self->pubMemAddr = pMemAddr;	/* Ƭɥ쥹 */
	self->MemSize    = MemSize;		/* ꥵ */
	self->FileSize   = IniSize;		/* եȤƤΥ */
	self->iAttr      = iAttr;		/* ° */
	
	/* ߥ塼ƥå */
	self->hMtx = SysMtx_Create(SYSMTX_ATTR_NORMAL);
}


/* end of file */
