/** 
 *  Hyper Operating System  Application Framework
 *
 * @file  memdrv_local.h
 * @brief %jp{ޥåץɥեѥǥХɥ饤 إåե}
 *
 * Copyright (C) 2006-2007 by Project HOS
 * http://sourceforge.jp/projects/hos/
 */


#ifndef __HOS__memdrv_local_h__
#define __HOS__memdrv_local_h__


#include "memdrv.h"
#include "system/file/drvobj_local.h"
#include "system/sysapi/sysapi.h"


/* ɥ饤 */
typedef struct c_memdrv
{
	C_DRVOBJ		DrvObj;			/* ǥХɥ饤ФѾ */

	int				iOpenCount;		/* ץ󥫥 */
	unsigned char	*pubMemAddr;	/* Ƭɥ쥹 */
	FILE_POS		MemSize;		/* ꥵ */
	FILE_POS		FileSize;		/* եȤƤΥ */
	int				iAttr;			/* ° */
	
	SYSMTX_HANDLE	hMtx;			/* ¾ѥߥ塼ƥå */
} C_MEMDRV;


#include "memfile_local.h"


#ifdef __cplusplus
extern "C" {
#endif

void      MemDrv_Constructor(C_MEMDRV *self, const T_DRVOBJ_METHODS *pMethods, void *pMemAddr, FILE_POS MemSize, FILE_POS IniSize, int iAttr);	/** 󥹥ȥ饯 */
void      MemDrv_Destructor(C_MEMDRV *self);																									/** ǥȥ饯 */

HANDLE    MemDrv_Open(C_DRVOBJ *pDrvObj, const char *pszPath, int iMode);
void      MemDrv_Close(C_DRVOBJ *pDrvObj, C_FILEOBJ *pFileObj);
FILE_ERR  MemDrv_IoControl(C_DRVOBJ *pDrvObj, C_FILEOBJ *pFileObj, int iFunc, void *pInBuf, FILE_SIZE InSize, const void *pOutBuf, FILE_SIZE OutSize);
FILE_POS  MemDrv_Seek(C_DRVOBJ *pDrvObj, C_FILEOBJ *pFileObj, FILE_POS Offset, int iOrign);
FILE_SIZE MemDrv_Read(C_DRVOBJ *pDrvObj, C_FILEOBJ *pFileObj, void *pBuf, FILE_SIZE Size);
FILE_SIZE MemDrv_Write(C_DRVOBJ *pDrvObj, C_FILEOBJ *pFileObj, const void *pData, FILE_SIZE Size);
FILE_ERR  MemDrv_Flush(C_DRVOBJ *pDrvObj, C_FILEOBJ *pFileObj);
FILE_ERR  MemDrv_GetInformation(C_DRVOBJ *pDrvObj, char *pszInformation, int iLen);

#ifdef __cplusplus
}
#endif


#endif	/* __HOS__memdrv_local_h__ */


/* end of file */
