/** 
 *  Hyper Operating System  Application Framework
 *
 * @file  at91usartdrv_constructor.c
 * @brief %jp{ATMEL AT91꡼USARTѥǥХɥ饤}
 *
 * Copyright (C) 2006-2007 by Project HOS
 * http://sourceforge.jp/projects/hos/
 */


#include "at91usartdrv_local.h"


/** 󥹥ȥ饯 */
FILE_ERR At91UsartDrv_Constructor(C_AT91USARTDRV *self, const T_DRVOBJ_METHODS *pMethods, void *pRegBase, int iIntNum, unsigned long ulBaseClock, int iBufSize)
{
	FILE_ERR	ErrCode;
	void		*pMem;

	/* Хåեѥ */
	if ( (pMem = SysMem_Alloc(iBufSize)) == NULL )
	{
		return FILE_ERR_NG;
	}
	
	/* ƥ饹󥹥ȥ饯ƤӽФ */
	if ( (ErrCode = SyncDrv_Constructor(&self->SyncDrv, pMethods, SYNCDRV_FACTOR_NUM)) != FILE_ERR_OK )
	{
		SysMem_Free(pMem);
		return ErrCode;
	}
	
	/* ѿ */
	self->pRegBase    = pRegBase;
	self->ulBaseClock = ulBaseClock;
	self->iIntNum     = iIntNum;
	self->iOpenCount  = 0;

	/* Хåե */
	StreamBuf_Create(&self->StmBufRecv, iBufSize, pMem);
	
	/* ߽Ͽ */
	self->hIsr = SysIsr_Create(self->iIntNum, At91UsartDrv_Isr, (VPARAM)self);

	return FILE_ERR_OK;
}


/* end of file */
