/** 
 * Hyper Operating System  Application Framework
 *
 * @file  jellyuartdrv_isr.c
 * @brief %jp{JellyUart ߥӥ롼}%en{JellyUart  interrupt service routine}
 *
 * Copyright (C) 2008 by Project HOS
 * http://sourceforge.jp/projects/hos/
 */


#include "jellyuartdrv_local.h"


/* ߽ */
void JellyUartDrv_IsrRx(VPARAM Param)
{
	C_JELLYUARTDRV	*self;
	int			c;
	
	self = (C_JELLYUARTDRV *)Param;
		
	/*  */	
	if ( (JELLYUART_REG_READ(self, JELLYUART_STATUS) & 0x01) )
	{
		/* Хåեɤ߽Ф */	
		do
		{
			/* Хåեɤ߽Ф */
			c = (int)JELLYUART_REG_READ(self, JELLYUART_DATA);
			StreamBuf_SendChar(&self->StmBufRecv, c);
		} while ( (JELLYUART_REG_READ(self, JELLYUART_STATUS) & 0x01) );
		
		/* ɹߥʥȯ */
		SyncDrv_SendSignal(&self->SyncDrv, SYNCDRV_FACTOR_READ);
	}
	
	/* װꥢ */
	SysInt_Clear(self->iIntNumRx);
}



/* ߽ */
void JellyUartDrv_IsrTx(VPARAM Param)
{
	C_JELLYUARTDRV	*self;
	
	self = (C_JELLYUARTDRV *)Param;
	
	/*  */	
	if ( (JELLYUART_REG_READ(self, JELLYUART_STATUS) & 0x02) )
	{
		/* ߶ػ */
		SysInt_Disable(self->iIntNumTx);
		
		/* ߥʥȯ */
		SyncDrv_SendSignal(&self->SyncDrv, SYNCDRV_FACTOR_WRITE);
	}
	
	/* װꥢ */
	SysInt_Clear(self->iIntNumTx);
}


/* end of file */
