/** 
 * Hyper Operating System  Application Framework
 *
 * @file  jellyuartdrv_local.h
 * @brief %jp{JellyUart إåե}%en{JellyUart private header file}
 *
 * Copyright (C) 2008 by Project HOS
 * http://sourceforge.jp/projects/hos/
 */


#ifndef __HOS__jellyuartdrv_local_h__
#define __HOS__jellyuartdrv_local_h__


#include "jellyuartdrv.h"
#include "system/file/syncdrv_local.h"
#include "library/container/streambuf/streambuf.h"
#include "system/sysapi/sysapi.h"


#define JELLYUART_DATA				0x00		/* Mode Register */
#define JELLYUART_STATUS			0x04		/* Control Register */


#define JELLYUART_REG_WRITE(self, offset, val)		SysIo_OutPortW(((char *)(self)->pRegBase + (offset)), val)
#define JELLYUART_REG_READ(self, offset)			SysIo_InPortW(((char *)(self)->pRegBase + (offset)))



/** %jp{ɥ饤Х饹}%en{Device driver class} */
typedef struct c_jellyuartdrv
{
	C_SYNCDRV		SyncDrv;		/**< %jp{ƱǽդǥХɥ饤ФѾ} */

	void			*pRegBase;		/**< %jp{쥸١ɥ쥹} */
	unsigned long	ulBaseClock;	/**< %jp{١å} */
	int				iIntNumRx;		/**< %jp{ֹ} */
	int				iIntNumTx;		/**< %jp{ֹ} */
	SYSISR_HANDLE	hIsrRx;			/**< %jp{ߥӥ롼ϥɥ} */
	SYSISR_HANDLE	hIsrTx;			/**< %jp{ߥӥ롼ϥɥ} */

	int				iOpenCount;		/**< %jp{ץ󥫥} */
	
	C_STREAMBUF		StmBufRecv;		/**< %jp{Хåե} */
} C_JELLYUARTDRV;




#ifdef __cplusplus
extern "C" {
#endif

FILE_ERR  JellyUartDrv_Constructor(C_JELLYUARTDRV *self, const T_DRVOBJ_METHODS *pMethods, void *pRegBase, int iIntNumRx, int iIntNumTx, int iBufSize);
																															/**< 󥹥ȥ饯 */
void      JellyUartDrv_Destructor(C_JELLYUARTDRV *self);																	/**< ǥȥ饯 */

HANDLE    JellyUartDrv_Open(C_DRVOBJ *pDrvObj, const char *pszPath, int iMode);
void      JellyUartDrv_Close(C_DRVOBJ *pDrvObj, C_FILEOBJ *pFileObj);
FILE_ERR  JellyUartDrv_IoControl(C_DRVOBJ *pDrvObj, C_FILEOBJ *pFileObj, int iFunc, void *pInBuf, FILE_SIZE InSize, const void *pOutBuf, FILE_SIZE OutSize);
FILE_POS  JellyUartDrv_Seek(C_DRVOBJ *pDrvObj, C_FILEOBJ *pFileObj, FILE_POS Offset, int iOrign);
FILE_SIZE JellyUartDrv_Read(C_DRVOBJ *pDrvObj, C_FILEOBJ *pFileObj, void *pBuf, FILE_SIZE Size);
FILE_SIZE JellyUartDrv_Write(C_DRVOBJ *pDrvObj, C_FILEOBJ *pFileObj, const void *pData, FILE_SIZE Size);
FILE_ERR  JellyUartDrv_Flush(C_DRVOBJ *pDrvObj, C_FILEOBJ *pFileObj);

void      JellyUartDrv_IsrRx(VPARAM Param);			/**< %jp{߽} */
void      JellyUartDrv_IsrTx(VPARAM Param);			/**< %jp{߽} */

#ifdef __cplusplus
}
#endif


#endif	/* __HOS__jellyuartdrv_local_h__ */


/* end of file */
