/** 
 *  Hyper Operating System  Application Framework
 *
 * @file  mn103scdrv.h
 * @brief %jp{MN103꡼ ꥢ륤󥿡եѥǥХɥ饤}
 *
 * Copyright (C) 2006-2007 by Project HOS
 * http://sourceforge.jp/projects/hos/
 */


#ifndef __HOS__mn103scdrv_h__
#define __HOS__mn103scdrv_h__


#include "system/file/syncdrv_local.h"
#include "library/container/streambuf/streambuf.h"


/* UARTɥ饤 */
typedef struct c_mn103scdrv
{
	C_SYNCDRV		SyncDrv;		/* 饯ǥХɥ饤ФѾ */
	
	void			*pRegBase;		/* 쥸١ɥ쥹 */
	int				iIntNumTx;		/* ֹ */
	int				iIntNumRx;		/* ֹ */
	SYSISR_HANDLE	hIsrTx;			/* ߥӥ롼ϥɥ */
	SYSISR_HANDLE	hIsrRx;			/* ߥӥ롼ϥɥ */
	
	int				iOpenCount;		/* ץ󥫥 */
	
	C_STREAMBUF		StmBufRecv;		/* Хåե */
} C_MN103SCDRV;



#ifdef __cplusplus
extern "C" {
#endif

HANDLE Mn103ScDrv_Create(void *pRegBase, int iIntNumRx, int iIntNumTx, int iBufSize);	/**<  */
void   Mn103ScDrv_Delete(HANDLE hDriver);												/**<  */

#ifdef __cplusplus
}
#endif


#endif	/* __HOS__mn103scdrv_h__ */


/* end of file */
