/** 
 *  Hyper Operating System  Application Framework
 *
 * @file  mx1uartdrv_create.c
 * @brief %jp{Freescale MX1 UARTѥǥХɥ饤}
 *
 * Copyright (C) 2006-2007 by Project HOS
 * http://sourceforge.jp/projects/hos/
 */


#include "mx1uartdrv_local.h"


/** 󥹥ȥ饯 */
FILE_ERR Mx1UartDrv_Constructor(C_MX1UARTDRV *self, const T_DRVOBJ_METHODS *pMethods, void *pRegBase, int iIntNum, unsigned long ulBaseClock, int iBufSize)
{
	FILE_ERR	ErrCode;
	void		*pMem;

	/* Хåեѥ */
	if ( (pMem = SysMem_Alloc(iBufSize)) == NULL )
	{
		return FILE_ERR_NG;
	}
	
	/* ƥ饹󥹥ȥ饯ƤӽФ */
	if ( (ErrCode = SyncDrv_Constructor(&self->SyncDrv, pMethods, SYNCDRV_FACTOR_NUM)) != FILE_ERR_OK )
	{
		SysMem_Free(pMem);
		return ErrCode;
	}

	/* ѿ */
	self->pRegBase    = pRegBase;
	self->ulBaseClock = ulBaseClock;
	self->iIntNum     = iIntNum;
	self->iOpenCount  = 0;

	/* Хåե */
	StreamBuf_Create(&self->StmBufRecv, iBufSize, pMem);
	
	/* ߽Ͽ */
	self->hIsrTx = SysIsr_Create(self->iIntNum + 4, Mx1UartDrv_IsrTx, (VPARAM)self);
	self->hIsrRx = SysIsr_Create(self->iIntNum + 5, Mx1UartDrv_IsrRx, (VPARAM)self);

	return FILE_ERR_OK;
}


/* end of file */
