/** 
 *  Hyper Operating System  Application Framework
 *
 * @file  mx1uartdrv_write.c
 * @brief %jp{Freescale MX1 UARTѥǥХɥ饤}
 *
 * Copyright (C) 2006-2007 by Project HOS
 * http://sourceforge.jp/projects/hos/
 */


#include "mx1uartdrv_local.h"


/** %jp{} */
FILE_SIZE Mx1UartDrv_Write(C_DRVOBJ *pDrvObj, C_FILEOBJ *pFileObj, const void *pData, FILE_SIZE Size)
{
	C_MX1UARTDRV		*self;
	C_SYNCFILE			*pFile;
	const unsigned char	*pubBuf;
	FILE_ERR			ErrCode;
	FILE_SIZE			i;
	int					c;
	
	/* upper cast */
	self  = (C_MX1UARTDRV *)pDrvObj;
	pFile = (C_SYNCFILE *)pFileObj;

	pubBuf = (const unsigned char *)pData;

	/* ߽ */
	if ( (ErrCode = SyncDrv_StartProcess(&self->SyncDrv, pFile, SYNCDRV_FACTOR_WRITE)) != FILE_ERR_OK )
	{
		return (FILE_SIZE)ErrCode;
	}
	
	/* ߥʥöꥢ */
	SyncFile_ClearSignal(pFile, SYNCDRV_FACTOR_WRITE);

	for ( i = 0; i < Size; i++ )
	{
		c = *pubBuf++;
		while ( !(MX1UART_REG_READ(self, MX1UART_USR2) & 0x0008) )
		{
#if 0
			/* ߵ */

			
			/* ֥å󥰥⡼ɤǤʤȴ */
			if ( SyncFile_GetSyncMode(pFile, SYNCDRV_FACTOR_WRITE) != FILE_SYNCMODE_BLOCKING )
			{
				SyncDrv_EndProcess(&self->SyncDrv, SYNCDRV_FACTOR_WRITE, i);
				return i;
			}
			
			/* ߥʥԤ */
			SyncFile_WaitSignal(pFile, SYNCDRV_FACTOR_WRITE);
			
			/* ߥʥ򥯥ꥢƥȥ饤 */
			SyncFile_ClearSignal(pFile, SYNCDRV_FACTOR_WRITE);
#endif
		}
		MX1UART_REG_WRITE(self, MX1UART_UTXD(0), c);
	}
	
	/* ߽λ */
	SyncDrv_EndProcess(&self->SyncDrv, SYNCDRV_FACTOR_WRITE, (VPARAM)i);

	return i;
}



/* end of file */
