/** 
 *  Hyper Operating System  Application Framework
 *
 * @file  scidrv_local.h
 * @brief %jp{Renesas H8/SH SCIǥХɥ饤}
 *
 * Copyright (C) 2006-2007 by Project HOS
 * http://sourceforge.jp/projects/hos/
 */


#ifndef __HOS__scidrv_local_h__
#define __HOS__scidrv_local_h__


#include "scidrv.h"
#include "system/file/syncdrv_local.h"
#include "system/sysapi/sysapi.h"
#include "library/container/streambuf/streambuf.h"
#include "scihal.h"


/* SCIѥɥ饤 */
typedef struct c_scidrv
{
	C_SYNCDRV		SyncDrv;		/* ƱǽդǥХɥ饤ФѾ */

	C_SCIHAL		SciHal;			/* ϡɥݲ饹 */

	int				iOpenCount;		/* ץ󥫥 */
	int				iIntNum;		/* ֹ */
	SYSISR_HANDLE	hIsrRxErr;		/* 顼ߥӥ롼ϥɥ */
	SYSISR_HANDLE	hIsrRx;			/* ߥӥ롼ϥɥ */
	SYSISR_HANDLE	hIsrTx;			/* ߥӥ롼ϥɥ */
	SYSISR_HANDLE	hIsrTxEnd;		/* λߥӥ롼ϥɥ */
	
	C_STREAMBUF		StmBufRecv;		/* Хåե */
} C_SCIDRV;


#ifdef __cplusplus
extern "C" {
#endif

FILE_ERR  SciDrv_Constructor(C_SCIDRV *self, const T_DRVOBJ_METHODS *pMethods, void *pRegBase, int iIntNum, unsigned long ulSysClock, int iBufSize);	/**< 󥹥ȥ饯 */
void      SciDrv_Destructor(C_SCIDRV *self);																											/**< ǥȥ饯 */

HANDLE    SciDrv_Open(C_DRVOBJ *pDrvObj, const char *pszPath, int iMode);
void      SciDrv_Close(C_DRVOBJ *pDrvObj, C_FILEOBJ *pFileObj);
FILE_ERR  SciDrv_IoControl(C_DRVOBJ *pDrvObj, C_FILEOBJ *pFileObj, int iFunc, void *pInBuf, FILE_SIZE InSize, const void *pOutBuf, FILE_SIZE OutSize);
FILE_POS  SciDrv_Seek(C_DRVOBJ *pDrvObj, C_FILEOBJ *pFileObj, FILE_POS Offset, int iOrign);
FILE_SIZE SciDrv_Read(C_DRVOBJ *pDrvObj, C_FILEOBJ *pFileObj, void *pBuf, FILE_SIZE Size);
FILE_SIZE SciDrv_Write(C_DRVOBJ *pDrvObj, C_FILEOBJ *pFileObj, const void *pData, FILE_SIZE Size);
FILE_ERR  SciDrv_Flush(C_DRVOBJ *pDrvObj, C_FILEOBJ *pFileObj);

void      SciDrv_IsrRxErr(VPARAM Param);	/* 顼 */
void      SciDrv_IsrRx(VPARAM Param);		/*  */
void      SciDrv_IsrTx(VPARAM Param);		/* ץƥ */
void      SciDrv_IsrTxEnd(VPARAM Param);	/* λ */

#ifdef __cplusplus
}
#endif


#endif	/* __HOS__scidrv_local_h__ */


/* end of file */
