/** 
 *  Hyper Operating System  Application Framework
 *
 * @file  scihdl.c
 * @brief %jp{SCIѥϡɥ}
 *
 * Copyright (C) 2006 by Project HOS
 * http://sourceforge.jp/projects/hos/
 */


#include "scihal_local.h"



/* %jp{1ʸ} */
int SciHal_RecvChar(C_SCIHAL *self)
{
	unsigned char ssr;
	int c;
	
	ssr = *SCIHAL_REG_SSR(self);
	
	/* 顼å */
	if ( ssr & 0x38 )
	{
		*SCIHAL_REG_SSR(self) = (ssr & ~0x38);
		return -1;
	}
	
	/* ǡå */
	if ( !(ssr & 0x40) )
	{
		return -1;
	}
	
	/*  */
	c = *SCIHAL_REG_RDR(self);
	
	*SCIHAL_REG_SSR(self) &= ~0x40;
	
	return c;
}


/* end of file */
