/** 
 *  Hyper Operating System  Application Framework
 *
 * @file  winsockdrv.h
 * @brief %jp{WinSockǥꥢ򵼻ɥ饤}
 *
 * Copyright (C) 2006-2007 by Project HOS
 * http://sourceforge.jp/projects/hos/
 */



#include "winsockdrv_local.h"


/**   */
HANDLE WinSockDrv_Create(int iPortNum, int iIntNum, int iBufSize)
{
	C_WINSOCKDRV *self;
	
	/*  */
	if ( (self = (C_WINSOCKDRV *)SysMem_Alloc(sizeof(C_WINSOCKDRV))) == NULL )
	{
		return HANDLE_NULL;
	}
	
	/* 󥹥ȥ饯ƤӽФ */
	if ( WinSockDrv_Constructor(self, NULL, iPortNum, iIntNum, iBufSize) != FILE_ERR_OK )
	{
		SysMem_Free(self);
		return HANDLE_NULL;
	}
	
	return (HANDLE)self;
}


/* end of file */
