/** 
 *  Hyper Operating System  Application Framework
 *
 * @file  winsockdrv.h
 * @brief %jp{WinSockǥꥢ򵼻ɥ饤}
 *
 * Copyright (C) 2006-2007 by Project HOS
 * http://sourceforge.jp/projects/hos/
 */



#include "winsockdrv_local.h"


/** 񤭹 */
FILE_SIZE WinSockDrv_Write(C_DRVOBJ *pDrvObj, C_FILEOBJ *pFileObj, const void *pData, FILE_SIZE Size)
{
	C_WINSOCKDRV		*self;
	C_SYNCFILE			*pFile;
	const unsigned char	*pubData;
	FILE_ERR			ErrCode;
	FILE_SIZE			SendSize = 0;
	int					iLen;
	
	/* upper cast */
	self  = (C_WINSOCKDRV *)pDrvObj;
	pFile = (C_SYNCFILE *)pFileObj;
	
	pubData = (const unsigned char *)pData;
	
	/* ߽ */
	if ( (ErrCode = SyncDrv_StartProcess(&self->SyncDrv, pFile, SYNCDRV_FACTOR_WRITE)) != FILE_ERR_OK )
	{
		return (FILE_SIZE)ErrCode;
	}

	/* ߥʥöꥢ */
	SyncFile_ClearSignal(pFile, SYNCDRV_FACTOR_WRITE);
	
	while ( Size > 0 )
	{
		/* ǽå */
		while ( (iLen = StreamBuf_SendData(&self->StmBufSend, pubData, Size)) <= 0 )
		{
			/* ֥å󥰥⡼ɤǤʤȴ */
			if ( SyncFile_GetSyncMode(pFile, SYNCDRV_FACTOR_WRITE) != FILE_SYNCMODE_BLOCKING )
			{
				SyncDrv_EndProcess(&self->SyncDrv, SYNCDRV_FACTOR_WRITE, SendSize);
				return SendSize;
			}
			
			/* ߥʥԤ */
			SyncFile_WaitSignal(pFile, SYNCDRV_FACTOR_WRITE);
			
			/* ߥʥ򥯥ꥢƥȥ饤 */
			SyncFile_ClearSignal(pFile, SYNCDRV_FACTOR_WRITE);
		}

		/* ʸФ */
		pubData  += iLen;
		Size     -= iLen;
		SendSize += iLen;
		
		/*  */
		SetEvent(self->hSendEvent);
	}
	
	/* ߽λ */
	SyncDrv_EndProcess(&self->SyncDrv, SYNCDRV_FACTOR_WRITE, (VPARAM)SendSize);
	
	return SendSize;
}


/* end of file */
