/** 
 *  Hyper Operating System  Application Framework
 *
 * @file  fatvol.c
 * @brief %jp{FATܥ塼ѥǥХɥ饤}
 *
 * Copyright (C) 2006-2007 by Project HOS
 * http://sourceforge.jp/projects/hos/
 */


#include <stdio.h>
#include "fatfile_local.h"


void FatFile_Constructor(C_FATFILE *self, const T_FILEOBJ_METHODS *pMethods, C_FATVOL *pFatVol, FATVOL_UINT uiStartCluster, FATVOL_UINT uiDirCluster, FATVOL_UINT uiDirEntryPos, FILE_POS FileSize, int iMode)
{
	/* ƥ饹󥹥ȥ饯 */
	FileObj_Constructor(&self->FileObj, pMethods, &pFatVol->VolumeObj.DrvObj, iMode);
	
	/* ѿ */
	self->uiStartCluster = uiStartCluster;
	self->uiDirCluster   = uiDirCluster;
	self->uiDirEntryPos  = uiDirEntryPos;
	self->FileSize       = FileSize;
	self->FilePos        = 0;				/* եݥ󥿽 */
	if ( iMode & FILE_OPEN_APPEND )
	{
		self->FilePos = self->FileSize;
	}
}


/* end of file */
