/** 
 *  Hyper Operating System  Application Framework
 *
 * @file  fatvol.h
 * @brief %jp{FATܥ塼ѥǥХɥ饤}
 *
 * Copyright (C) 2006-2007 by Project HOS
 * http://sourceforge.jp/projects/hos/
 */


#ifndef __HOS__fatvol_local_h__
#define __HOS__fatvol_local_h__


#include "fatvol.h"
#include "system/file/volumeobj_local.h"


/* ǽ饹ޡ */
#define FATVOL_CLUSTER_FREE				0x00000000
#define FATVOL_CLUSTER_ENDMARKER		0x0fffffff


/* ե륷ƥΥ */
#define FATVOL_TYPE_UNKNOWN				0
#define FATVOL_TYPE_FAT12				1
#define FATVOL_TYPE_FAT16				2
#define FATVOL_TYPE_FAT32				3


/* 饹Хåե */
typedef struct t_fatvol_clusterbuf
{
	FATVOL_UINT		uiClusterNum;
	int				iDirty;
	unsigned char	*pubBuf;
} T_FATVOL_CLUSTERBUF;


/* 饹Хåե */
typedef struct c_fatvol
{
	C_VOLUMEOBJ			VolumeObj;					/* ܥ塼४֥ȤѾ */

	HANDLE				hBlockFile;					/**< ֥åǥХɥ饤ФΥϥɥ */
	
	SYSMTX_HANDLE		hMtx;						/**< åѥߥ塼ƥå */
	
	int					iShutdown;					/**< åȥե饰 */
	int					iOpenCount;					/**< ץ󥫥 */
	
	int					iFatType;					/**< FATΥ */
	FILE_POS			Offset;						/**< ǥΥեå */
	FILE_POS			DriveSize;					/**< ɥ饤֤ */
	FATVOL_UINT			BytesPerSector;				/**<  */
	FATVOL_UINT			SectorsPerCluster;			/**< 饹Υ */
	FATVOL_UINT			BytesPerCluster;			/**< 饹 */
	FATVOL_UINT			FatStartSector;				/**< FATγϥֹ */
	FATVOL_UINT			SectorNum;					/**<  */
	FATVOL_UINT			SectorPerFat;				/**< FATΥ */
	FATVOL_UINT			FatNum;						/**< FATθĿ */
	FATVOL_UINT			RootDirEntryNum;			/**< 롼ȥǥ쥯ȥΥȥ */
	FATVOL_UINT			RootDirSector;				/**< 롼ȥǥ쥯ȥΥ */
	FATVOL_UINT			Cluster0Sector;				/**< 饹0Υֹ */
	FATVOL_UINT			ClusterNum;					/**< 饹 */
	FATVOL_UINT			RootDirCluster;				/**< 롼ȥǥ쥯ȥΥ饹ֹ */
	
	unsigned char		*pubFatBuf;					/**< FATΥХåե󥰥 */
	unsigned char		*pubFatDirty;				/**< FATιե饰 */
	
	struct t_fatvol_clusterbuf	*pClusterBuf;
	int							iClusterBufNum;
} C_FATVOL;


#include "fatfile.h"


struct c_fatfile;

#ifdef __cplusplus
extern "C" {
#endif

FATVOL_ERR          FatVol_Constructor(C_FATVOL *self, const T_VOLUMEOBJ_METHODS *pMethods, const char *pszPath);
void                FatVol_Destructor(C_FATVOL *self);

HANDLE              FatVol_Open(C_DRVOBJ *pDrvObj, const char *pszPath, int iMode);
void                FatVol_Close(C_DRVOBJ *pDrvObj, C_FILEOBJ *pFileObj);
FILE_ERR            FatVol_IoControl(C_DRVOBJ *pDrvObj, C_FILEOBJ *pFileObj, int iFunc, void *pInBuf, FILE_SIZE InSize, const void *pOutBuf, FILE_SIZE OutSize);
FILE_POS            FatVol_Seek(C_DRVOBJ *pDrvObj, C_FILEOBJ *pFileObj, FILE_POS Offset, int iOrign);
FILE_SIZE           FatVol_Read(C_DRVOBJ *pDrvObj, C_FILEOBJ *pFileObj, void *pBuf, FILE_SIZE Size);
FILE_SIZE           FatVol_Write(C_DRVOBJ *pDrvObj, C_FILEOBJ *pFileObj, const void *pData, FILE_SIZE Size);
FILE_ERR            FatVol_Flush(C_DRVOBJ *pDrvObj, C_FILEOBJ *pFileObj);

FILE_ERR            FatVol_Shutdown(C_VOLUMEOBJ *pVolObj);														/**< åȥ */
FILE_ERR            FatVol_MakeDir(C_VOLUMEOBJ *pVolObj, const char *pszPath);									/**< ֥ǥ쥯ȥ */
FILE_ERR            FatVol_Remove(C_VOLUMEOBJ *pVolObj, const char *pszPath);									/**< ե */

void                FatVol_SyncFileSize(C_FATVOL *self, struct c_fatfile *pFile);								/**< Ʊ */

int                 FatVol_ClusterWrite(C_FATVOL *self, FATVOL_UINT uiCluster, const void *pBuf);				/**< 饹񤭹 */
int                 FatVol_ClusterRead(C_FATVOL *self, FATVOL_UINT uiCluster, void *pBuf);						/**< 饹ɤ߹ */

T_FATVOL_CLUSTERBUF *FatVol_GetClusterBuf(C_FATVOL *self, FATVOL_UINT uiCluster, int iRead);
void                FatVol_RelClusterBuf(C_FATVOL *self, T_FATVOL_CLUSTERBUF *pClusterBuf, int iDirty);							
void                FatVol_FlushClusterBuf(C_FATVOL *self);

FATVOL_UINT         FatVol_AllocCluster(C_FATVOL *self);
void                FatVol_FreeCluster(C_FATVOL *self, FATVOL_UINT uiCluster);
FATVOL_UINT         FatVol_GetNextCluster(C_FATVOL *self, FATVOL_UINT uiCluster);
void                FatVol_SetNextCluster(C_FATVOL *self, FATVOL_UINT uiCluster, FATVOL_UINT uiNextCluster);


void        FatVol_FlushFat(C_FATVOL *self);


#ifdef __cplusplus
}
#endif


#endif	/*  __HOS__fatvol_local_h__ */


/* end of file */
