/** 
 *  Hyper Operating System  Application Framework
 *
 * @file  fatvol.c
 * @brief %jp{FATܥ塼ѥǥХɥ饤}
 *
 * Copyright (C) 2006-2007 by Project HOS
 * http://sourceforge.jp/projects/hos/
 */



#include <string.h>
#include "fatvol_local.h"


/** %jp{ɽФ} */
FILE_SIZE FatVol_Read(C_DRVOBJ *pDrvObj, C_FILEOBJ *pFileObj, void *pBuf, FILE_SIZE Size)
{
	C_FATVOL		*self;
	C_FATFILE		*pFile;
	FILE_SIZE		ReqSize;
	unsigned char	*pubBuf;
	FATVOL_UINT		uiCluster;
	FATVOL_UINT		i;
	
	/* upper cast */
	self  = (C_FATVOL *)pDrvObj;
	pFile = (C_FATFILE *)pFileObj;
	
	pubBuf = (unsigned char *)pBuf;


	/* ƥ륻 */
	SysMtx_Lock(self->hMtx);
	
	/* å */
	if ( !(FileObj_GetMode(&pFile->FileObj) & FILE_OPEN_DIR) )
	{
		if ( Size > pFile->FileSize - pFile->FilePos )
		{
			/* Ƥʤǥ쥯ȥơ֥򻲾Ȥ٤ */

			/* å */
			Size = (FILE_SIZE)(pFile->FileSize - pFile->FilePos);
		}
	}
	
	/* ׵ɤ߽Ф¸ */
	ReqSize = Size;
	
	/* 饹򸡺 */
	uiCluster = pFile->uiStartCluster;
	for ( i = 0; pFile->FilePos >= (FILE_POS)((i + 1) * self->BytesPerCluster); i++ )
	{
		uiCluster = FatVol_GetNextCluster(self, uiCluster);
	}
	
	/* ɤ߽Ф */
	while ( Size > 0 && (pFile->FilePos < pFile->FileSize || (FileObj_GetMode(&pFile->FileObj) & FILE_OPEN_DIR)) )
	{
		FILE_POS 			ReadStart;
		FILE_SIZE			ReadSize;
		T_FATVOL_CLUSTERBUF *pClusterBuf;
		
		/* 饹å */
		if ( uiCluster == FATVOL_CLUSTER_ENDMARKER )
		{
			break;
		}
		
		/* žַ׻ */
		ReadStart = (pFile->FilePos & (self->BytesPerCluster) - 1);
		ReadSize  = (FILE_SIZE)(self->BytesPerCluster - ReadStart);
		if ( ReadSize > Size )
		{
			ReadSize     = Size;
		}
		
		/* Хåե */
		if ( (pClusterBuf = FatVol_GetClusterBuf(self, uiCluster, 1)) == NULL )
		{
			break;
		}

		/* ž */
		memcpy(pubBuf, &pClusterBuf->pubBuf[ReadStart], ReadSize);

		/* Хåե */
		FatVol_RelClusterBuf(self, pClusterBuf, 0);
		
		/*  */
		pFile->FilePos += ReadSize;
		pubBuf         += ReadSize;
		Size           -= ReadSize;
		
		/* Υ饹˿ʤ */
		uiCluster = FatVol_GetNextCluster(self, uiCluster);
		
		/* öå */
		SysMtx_Unlock(self->hMtx);
		SysMtx_Lock(self->hMtx);
	}
	
	/* ƥ륻Ф */
	SysMtx_Unlock(self->hMtx);
	
	return ReqSize - Size;
}


/* end of file */
