/** 
 *  Hyper Operating System  Application Framework
 *
 * @file  fatvol.c
 * @brief %jp{FATܥ塼ѥǥХɥ饤}
 *
 * Copyright (C) 2006-2007 by Project HOS
 * http://sourceforge.jp/projects/hos/
 */


#include <string.h>
#include "fatvol_local.h"


/** %jp{񤭹} */
FILE_SIZE FatVol_Write(C_DRVOBJ *pDrvObj, C_FILEOBJ *pFileObj, const void *pData, FILE_SIZE Size)
{
	C_FATVOL			*self;
	C_FATFILE			*pFile;

	FILE_SIZE			ReqSize;
	const unsigned char	*pubData;
	FATVOL_UINT			uiNextCluster;
	FATVOL_UINT			uiCluster;
	FATVOL_UINT			i;
	int                 iResizeFlag = 0;

	
	/* upper cast */
	self  = (C_FATVOL *)pDrvObj;
	pFile = (C_FATFILE *)pFileObj;

	/* 㥹 */
	pubData = (const unsigned char *)pData;

	/* 0ʤ¨ */
	if ( Size <= 0 )
	{
		return 0;
	}

	/* ƥ륻 */
	SysMtx_Lock(self->hMtx);
	
	/* ⡼ɥå */
	if ( !(FileObj_GetMode(&pFile->FileObj) & FILE_OPEN_WRITE) || (FileObj_GetMode(&pFile->FileObj) & FILE_OPEN_DIR) )
	{
		SysMtx_Unlock(self->hMtx);
		return 0;
	}
		
	/* 񤭹׵¸ */
	ReqSize = Size;
	
	/* եݥ󥿰֤Υ饹򸡺 */
	uiCluster = pFile->uiStartCluster;
	for ( i = 0; pFile->FilePos >= (FILE_POS)((i + 1) * self->BytesPerCluster); i++ )
	{
		/* Υ饹õ */
		uiNextCluster = FatVol_GetNextCluster(self, uiCluster);
		if ( uiNextCluster == FATVOL_CLUSTER_ENDMARKER )
		{
			/* 饹̵к */
			uiNextCluster = FatVol_AllocCluster(self);
			if ( uiNextCluster == FATVOL_CLUSTER_ENDMARKER )
			{
				return 0;	/* ǥե */
			}
			FatVol_SetNextCluster(self, uiCluster, uiNextCluster);
		}
		uiCluster = uiNextCluster;
	}
	
	
	/* 񤭽Ф */
	while ( Size > 0 )
	{
		FILE_POS			WriteStart;
		FILE_SIZE			WriteSize;
		T_FATVOL_CLUSTERBUF	*pClusterBuf;
				
		/* žַ׻ */
		WriteStart = (pFile->FilePos & (self->BytesPerCluster - 1));
		WriteSize  = (FILE_SIZE)(self->BytesPerCluster - WriteStart);
		if ( WriteSize > Size )
		{
			WriteSize = Size;
		}

		/* Хåե */
		if ( WriteStart == 0 && pFile->FilePos == pFile->FileSize )
		{
			pClusterBuf = FatVol_GetClusterBuf(self, uiCluster, 0);		/* ξ */
		}
		else
		{
			pClusterBuf = FatVol_GetClusterBuf(self, uiCluster, 1);		/* ʬξ */
		}
		if ( pClusterBuf == NULL )
		{
			break;
		}

		/* ž */
		memcpy(&pClusterBuf->pubBuf[WriteStart], pubData, WriteSize);
	
		/* Хåե */
		FatVol_RelClusterBuf(self, pClusterBuf, 1);
		
		
		/*  */
		pFile->FilePos += WriteSize;
		pubData        += WriteSize;
		Size           -= WriteSize;
		
		/* ե륵 */
		if ( pFile->FileSize < pFile->FilePos )
		{
			pFile->FileSize = pFile->FilePos;
			iResizeFlag     = 1;
		}
		
		/* λå */
		if ( Size <= 0 )
		{
			break;
		}
		
		/* Υ饹õ */
		uiNextCluster = FatVol_GetNextCluster(self, uiCluster);
		if ( uiNextCluster == FATVOL_CLUSTER_ENDMARKER )
		{
			/* 饹̵к */
			uiNextCluster = FatVol_AllocCluster(self);
			if ( uiNextCluster == FATVOL_CLUSTER_ENDMARKER )
			{
				break;	/* ǥե */
			}
			FatVol_SetNextCluster(self, uiCluster, uiNextCluster);
		}
		uiCluster = uiNextCluster;
		
		/* öå */
		SysMtx_Unlock(self->hMtx);
		SysMtx_Lock(self->hMtx);		
	}
	
	/* ǥ쥯ȥơ֥Υ */
	if ( iResizeFlag &&	!(FileObj_GetMode(&pFile->FileObj) & FILE_OPEN_DIR) )
	{
		FatVol_SyncFileSize(self, pFile);
	}

	/* ƥ륻Ф */
	SysMtx_Unlock(self->hMtx);
	
	return ReqSize - Size;	
}


/* end of file */
