/** 
 *  Hyper Operating System  Application Framework
 *
 * @file  stringformat.c
 * @brief %jp{ʸեޥå饤֥}
 *
 * Copyright (C) 2008 by Project HOS
 * http://sourceforge.jp/projects/hos/
 */


#include "stringformat_local.h"



/* դ10ʿ */
int StringFormat_Decimal(int (*pfncPut)(int c, void *Param), void *Param, long lNum, int iSigned, int iWidth, int iPadChar, int iFlag)
{
	unsigned long	ulNum;
	char			szBuf[10];
	int  			iLen = 0;
	int  			iSignChar;
	int				iPadSize;
	int  			iSign;
	int  			iSize;
	
	/* å */
	if ( lNum < 0 && iSigned )
	{
		ulNum = -lNum;
		iSign = 1;
		iSignChar = '-';
	}
	else
	{
		ulNum = lNum;
		iSign = (iFlag == '+') ? 1 : 0;
		iSignChar = '+';
	}
	
	/* ʸѴ */
	iSize = 0;
	do
	{
		szBuf[iSize++] = (char)((ulNum % 10) + '0');
		ulNum         /= 10;
	} while ( ulNum != 0 );
	
	/* ѥƥ󥰥 */
	iPadSize = iWidth - iSize - iSign;
	
	/* °̵˥ѥǥ */
	if ( iFlag != '-' )
	{
		while ( iWidth > iSize + iSign )
		{
			iWidth--;
			if ( pfncPut(iPadChar, Param) <= 0 )
			{
				return iLen;
			}
			iLen++;
		}
	}
	
	/*  */
	if ( iSign )
	{
		if ( pfncPut(iSignChar, Param) <= 0 )
		{
			return iLen;
		}
		iLen++;
	}
	
	/* ͽ */
	do
	{
		 if ( pfncPut(szBuf[--iSize], Param) <= 0 )
		{
			return iLen;
		}
		iLen++;
	} while ( iSize > 0);
		
	/* °ʤѥǥ */
	if ( iFlag == '-' )
	{
		while ( iPadSize > 0 )
		{
			if ( pfncPut(' ', Param) <= 0 )
			{
				return iLen;
			}
			iLen++;

			iPadSize--;
		}
	}
	
	return iLen;
}


/* end of file */
