/** 
 *  Hyper Operating System  Application Framework
 *
 * @file  stringformat.c
 * @brief %jp{ʸեޥå饤֥}
 *
 * Copyright (C) 2008 by Project HOS
 * http://sourceforge.jp/projects/hos/
 */


#include "stringformat_local.h"



/* 16ʿ */
int StringFormat_Hexadecimal(int (*pfncPut)(int c, void *Param), void *Param, unsigned long ulNum, int iWidth, int iPadChar, int iFlag)
{
	unsigned long	ulTmp;
	int				iLen = 0;
	int				iSize = 0;
	int				iPadSize;
	
	
	/* ɽɬפʥ򻻽 */
	ulTmp = ulNum;
	do
	{
		iSize++;
		ulTmp >>= 4;
	} while ( ulTmp != 0 );
	
	/* ѥƥ󥰥 */
	iPadSize = iWidth - iSize;
	
	/* °̵˥ѥǥ */
	if ( iFlag != '-' )
	{
		while ( iPadSize > 0 )
		{
			if ( pfncPut(iPadChar, Param) <= 0 )
			{
				return iLen;
			}
			iLen++;

			iPadSize--;
		}
	}
	
	/* ̷夫˽ */
	iSize = (iSize - 1) * 4;
	do
	{
		if ( StringFormat_Nibble(pfncPut, Param, (unsigned char)(ulNum >> iSize)) <= 0 )
		{
			return iLen;
		}
		iLen++;
		
		iSize -= 4;
	} while ( iSize >= 0 );
	
	
	/* °ʤѥǥ */
	if ( iFlag == '-' )
	{
		while ( iPadSize > 0 )
		{
			if ( pfncPut(' ', Param) <= 0 )
			{
				return iLen;
			}
			iLen++;

			iPadSize--;
		}
	}
	
	return iLen;
}


/* end of file */
