/** 
 *  Hyper Operating System  Application Framework
 *
 * @file  automemheap_local.h
 * @brief %jp{ҡץ饹}%en{auto size memory heap class}
 *
 * Copyright (C) 2006-2008 by Project HOS
 * http://sourceforge.jp/projects/hos/
 */



#ifndef __HOS__automemheap_local_h__
#define __HOS__automemheap_local_h__


#include "library/container/memheap/memheap_local.h"
#include "library/container/valmemheap/valmemheap_local.h"
#include "library/container/fixmemheap/fixmemheap_local.h"


typedef struct t_automemheap_fix
{
	struct t_automemheap_fix	*pNext;
	C_FIXMEMHEAP				FixMemHeap;
} T_AUTOMEMHEAP_FIX;

typedef struct t_automemheap_val
{
	struct t_automemheap_val	*pNext;
	C_VALMEMHEAP				ValMemHeap;
} T_AUTOMEMHEAP_VAL;

typedef struct t_automemheap_mem
{
	struct t_automemheap_mem	*pNext;
} T_AUTOMEMHEAP_MEM;


/** %jp{AutoMemHeap饹}%en{AutoMemHeap class} */
typedef struct c_automemheap
{
	C_MEMHEAP			MemHeap;		/**< Ѿ */

	C_MEMHEAP			*pMemHeap;		/**< ҡ */
	
	T_AUTOMEMHEAP_FIX	*pFixList;		/**< ֥åѸꥵҡץꥹ */
	T_AUTOMEMHEAP_VAL	*pValList;		/**< ֥åѲѥҡץꥹ */
	T_AUTOMEMHEAP_MEM	*pMemList;		/**< ֥åѥꥹ */
	
	MEMSIZE				FixSize;		/**< ֥å */
	MEMSIZE				FixNum;			/**< ֥åĿ */
	MEMSIZE				ValSize;		/**< ֥å */
	
	int					iFixMax;
	int					iValMax;
} C_AUTOMEMHEAP;


#ifdef __cplusplus
extern "C" {
#endif

void       AutoMemHeap_Constructor(C_AUTOMEMHEAP *self, C_MEMHEAP *pMemHeap);	/**< 󥹥ȥ饯 */
void       AutoMemHeap_Destructor(C_AUTOMEMHEAP *self);							/**< ǥȥ饯 */

void	  *AutoMemHeap_Alloc(void *pMemHeap, MEMSIZE Size);						/**< γ */
void	  *AutoMemHeap_ReAlloc(void *pMemHeap, void *pMem, MEMSIZE Size);		/**< κƳ */
void	   AutoMemHeap_Free(void *pMemHeap, void *pMem);						/**< γ */
MEMSIZE	   AutoMemHeap_GetSize(void *pMemHeap, void *pMem);						/**< Υ */
MEMSIZE	   AutoMemHeap_GetAlign(void *pMemHeap);								/**< ꥢ饤Ȥμ */
MEMSIZE	   AutoMemHeap_AlignSize(void *pMemHeap, MEMSIZE Size);					/**< 򥢥饤ñ̤˳ĥ */
int        AutoMemHeap_IsMember(void *pMemHeap, void *pMem);					/**< 򥢥饤ñ̤˳ĥ */

C_MEMHEAP *AutoMemHeap_SearchHeap(C_AUTOMEMHEAP *self, void *pMem);				/**< °ҡפ򸡺 */

#ifdef __cplusplus
}
#endif



#endif	/* __HOS__automemheap_local_h__ */


/* end of file */
