/** 
 *  Hyper Operating System  Application Framework
 *
 * @file  automemheap_free.c
 * @brief %jp{ҡץ饹}%en{auto size memory heap class}
 *
 * Copyright (C) 2006-2009 by Project HOS
 * http://sourceforge.jp/projects/hos/
 */


#include <stdio.h>
#include "automemheap_local.h"


/** °ҡפ򸡺 */
C_MEMHEAP *AutoMemHeap_SearchHeap(C_AUTOMEMHEAP *self, void *pMem)
{
	T_AUTOMEMHEAP_FIX	*pFixHeap;
	T_AUTOMEMHEAP_VAL	*pValHeap;
	
	/* Ĺҡפ̵õ */
	for ( pFixHeap = self->pFixList; pFixHeap != NULL; pFixHeap = pFixHeap->pNext )
	{
		if ( FixMemHeap_IsMember(&pFixHeap->FixMemHeap, pMem) )
		{
			return &pFixHeap->FixMemHeap.MemHeap;
		}
	}
	
	/* Ĺҡפ̵õ */
	for ( pValHeap = self->pValList; pValHeap != NULL; pValHeap = pValHeap->pNext )
	{
		if ( ValMemHeap_IsMember(&pValHeap->ValMemHeap, pMem) )
		{
			return &pValHeap->ValMemHeap.MemHeap;
		}
	}
	
	return NULL;
}


/* end of file */
