/** 
 *  Hyper Operating System  Application Framework
 *
 * @file  fixmemheap_local.h
 * @brief %jp{ꥵҡץ饹}%en{fixed size memory heap class}
 *
 * Copyright (C) 2006-2008 by Project HOS
 * http://sourceforge.jp/projects/hos/
 */



#ifndef __HOS__fixmemheap_local_h__
#define __HOS__fixmemheap_local_h__


#include "library/container/memheap/memheap_local.h"



/** %jp{FixMemHeap饹}%en{FixMemHeap class} */
typedef struct c_fixmemheap
{
	C_MEMHEAP			MemHeap;		/* Ѿ */
	
	void				*pMemBase;		/**< %jp{Ƭ֥åΥɥ쥹} */
	void				**ppFree;		/**< %jp{֥åɥ쥹} */

	MEMSIZE				BlkSize;		/**< %jp{֥å} */
	MEMSIZE				BlkNum;			/**< %jp{֥åĿ} */
} C_FIXMEMHEAP;


#ifdef __cplusplus
extern "C" {
#endif

void	FixMemHeap_Constructor(C_FIXMEMHEAP *self, void *pMemBase, MEMSIZE BlkSize,  MEMSIZE BlkNum);
#define FixMemHeap_Destructor(self)			do { } while (0)

void	*FixMemHeap_Alloc(void *pMemHeap, MEMSIZE Size);					/**< γ */
void	*FixMemHeap_ReAlloc(void *pMemHeap, void *pMem, MEMSIZE Size);		/**< κƳ */
void	FixMemHeap_Free(void *pMemHeap, void *pMem);						/**< γ */
MEMSIZE	FixMemHeap_GetSize(void *pMemHeap, void *pMem);						/**< Υ */
MEMSIZE	FixMemHeap_GetAlign(void *pMemHeap);								/**< ꥢ饤Ȥμ */
MEMSIZE	FixMemHeap_AlignSize(void *pMemHeap, MEMSIZE Size);					/**< 򥢥饤ñ̤˳ĥ */
int     FixMemHeap_IsMember(void *pMemHeap, void *pMem);					/**< ꤬ҡפ°Ƥ뤫å */

#ifdef __cplusplus
}
#endif



#endif	/* __HOS__fixmemheap_local_h__ */


/* end of file */
