/** 
 *  Hyper Operating System  Application Framework
 *
 * @file  packetbuf.h
 * @brief %jp{ѥåȥǡѥХåե饹}
 *
 * Copyright (C) 2002-2007 by Project HOS
 * http://sourceforge.jp/projects/hos/
 */


#include "packetbuf_local.h"



/** ѥХåեμ(ʥԡ) */
unsigned int PacketBuf_GetBuf(C_PACKETBUF *self, void **ppBuf, unsigned int uiSize)
{
	unsigned int uiAllocSize;
	
	/* ƥ׻ */
	uiAllocSize = PACKETBUF_DATASIZE(uiSize) + sizeof(unsigned int);
	
	/* Ʋǽå */
	if ( self->uiTail >= self->uiHead )
	{
		if ( self->uiTail > self->uiBufSize - uiAllocSize )
		{
			/* ޤ֤ǽå */
			if ( self->uiHead <= uiAllocSize )
			{
				return 0;	/* Բ */
			}
			
			/* ޤ֤ */
			self->uiReturnPoint = self->uiTail;
			self->uiTail        = 0;
		}
	}
	else
	{
		if ( self->uiHead - self->uiTail <= uiAllocSize )
		{
			return 0;	/* Բ */
		}
	}
	
	/* ƤХåե֤ */
	*ppBuf = (void *)(self->pubBuf + self->uiTail + sizeof(unsigned int));
	
	return uiSize;	/* Ƥ֤ */
}


/* end of file */
