/** 
 *  Hyper Operating System  Application Framework
 *
 * @file  streambuf.h
 * @brief %jp{ȥ꡼ǡѥХåե饹}
 *
 * Copyright (C) 2002-2007 by Project HOS
 * http://sourceforge.jp/projects/hos/
 */


#include <string.h>
#include "streambuf_local.h"


/** ǡ */
unsigned int StreamBuf_SendData(C_STREAMBUF *self, const void *pData, unsigned int uiSize)
{
	void 			*pBuf;				/* Хåեɥ쥹 */
	unsigned int	uiBufSize;			/* Хåե */
	unsigned int	uiSendSize = 0;		/*  */

	do
	{
		/* Хåե */
		if ( (uiBufSize = StreamBuf_GetBuf(self, &pBuf)) <= 0 )
		{
			break;
		}
		
		/* ׻ */
		if ( uiBufSize > uiSize )
		{
			uiBufSize = uiSize;
		}
		
		/* ǡԡ */
		memcpy(pBuf, pData, uiBufSize);
		
		/*  */
		StreamBuf_SendBuf(self, uiBufSize);
		
		/* ݥ󥿹 */
		pData       = (void *)((char *)pData + uiBufSize);
		uiSize     -= uiBufSize;
		uiSendSize += uiBufSize;
	} while ( uiSize > 0 );
	
	
	return uiSendSize;		/* ֤ */
}


/* end of file */
