/** 
 *  Hyper Operating System  Application Framework
 *
 * @file  valmemheap_alloc.c
 * @brief %jp{ѥҡץ饹}%en{variable size memory heap class}
 *
 * Copyright (C) 2006-2008 by Project HOS
 * http://sourceforge.jp/projects/hos/
 */


#include <stdio.h>
#include "valmemheap_local.h"



/** %jp{γ} */
void *ValMemHeap_Alloc(void *pMemHeap, MEMSIZE Size)
{
	C_VALMEMHEAP		*self;
	T_VALMEMHEAP_MEMBLK	*mblk;
	T_VALMEMHEAP_MEMBLK	*mblk_next;
	T_VALMEMHEAP_MEMBLK	*mblk_next2;
	MEMSIZE				MemBlockSize;
	
	
	/* upper cast */
	self = (C_VALMEMHEAP *)pMemHeap;
	
	/* %jp{ҡפ¸ߥå} */
	if ( self->pMemBase == NULL )
	{
		return NULL;
	}
	
	/* %jp{Υ饤ȤĴ} */
	Size = ValMemHeap_AlignSize(self, Size);
	
	/* %jp{֥åΥĴ} */
	MemBlockSize = ValMemHeap_GetMemBlockSize(self);
	
	/* %jp{ΰ򸡺} */
	mblk = self->pMemBase;
	while ( mblk->Size != 0 )
	{
		if ( mblk->iFlag == VALMEMHEAP_FREE && mblk->Size >= Size )
		{
			/* ʬ̤ä */
			if ( mblk->Size - Size > MemBlockSize + (self->AlignMask + 1) )
			{
				/* ֥åʬ䤹 */
				mblk_next  = (T_VALMEMHEAP_MEMBLK *)((char *)mblk + MemBlockSize + Size);
				mblk_next2 = (T_VALMEMHEAP_MEMBLK *)((char *)mblk + MemBlockSize + mblk->Size);
				mblk_next->pPrev  = mblk;
				mblk_next->Size   = mblk->Size - Size - MemBlockSize;
				mblk_next->iFlag  = VALMEMHEAP_FREE;
				mblk_next2->pPrev = mblk_next;
				mblk->Size        = Size;
			}
			mblk->iFlag = VALMEMHEAP_USING;
			
			return (void *)((char *)mblk + MemBlockSize);
		}
		
		/* Υ֥åؿʤ */
		mblk = (T_VALMEMHEAP_MEMBLK *)((char *)mblk + mblk->Size + MemBlockSize);
	}

	return NULL;	/* ̵ */
}

/* end of file */
