/** 
 *  Hyper Operating System  Application Framework
 *
 * @file  valmemheap_alloc.c
 * @brief %jp{ѥҡץ饹}%en{variable size memory heap class}
 *
 * Copyright (C) 2006-2008 by Project HOS
 * http://sourceforge.jp/projects/hos/
 */


#include <stdio.h>
#include "valmemheap_local.h"



/** %jp{MemHeap饹 ۴ؿơ֥}%en{MemHeap class virtual function table} */
const static T_MEMHEAP_METHODS ValMemHeap_Methods =
	{
		ValMemHeap_Alloc,			/**< γ */
		ValMemHeap_ReAlloc,			/**< κƳ */
		ValMemHeap_Free,			/**< γ */
		ValMemHeap_GetSize,			/**< Υ */
		ValMemHeap_GetAlign,		/**< ꥢ饤Ȥμ */
		ValMemHeap_AlignSize,		/**< 򥢥饤ñ̤˳ĥ */
		ValMemHeap_IsMember,		/**< ꤬ҡפ°Ƥ뤫å */
	};



/** %jp{󥹥ȥ饯} */
void ValMemHeap_Constructor(C_VALMEMHEAP *self, void *pMemBase, MEMSIZE MemSize, int AlignSize)
{
	T_VALMEMHEAP_MEMBLK *pBlkLast;
	MEMSIZE				MemBlockSize;
	
	
	/* %jp{ƥ饹󥹥ȥ饯} */
	MemHeap_Constructor(&self->MemHeap, &ValMemHeap_Methods);

	/* %jp{Υ饤ȤĴ} */
	MemSize = MemSize & ~(AlignSize - 1);
	
	/* ѿ */
	self->pMemBase  = (T_VALMEMHEAP_MEMBLK *)pMemBase;		/**< %jp{Ƭ֥åΥɥ쥹} */
	self->MemSize   = MemSize;								/**< %jp{ꥵ} */
	self->AlignMask = AlignSize - 1;						/**< %jp{ꥢ饤ȥ} */

	/* %jp{֥åΥĴ} */
	MemBlockSize = ValMemHeap_GetMemBlockSize(self);

	/* %jp{å} */
	if ( MemSize <= MemBlockSize * 2 )
	{
		self->pMemBase = NULL;
		return;
	}
	
	/* %jp{üֿ֤ͤ} */
	pBlkLast = (T_VALMEMHEAP_MEMBLK *)((char *)self->pMemBase + MemSize - MemBlockSize);
	
	/* %jp{Τΰ} */
	self->pMemBase->pPrev = NULL;
	self->pMemBase->Size = MemSize - (MemBlockSize * 2);
	self->pMemBase->iFlag = VALMEMHEAP_FREE;
	
	/* %jp{üֿͤ} */
	pBlkLast->pPrev = NULL;
	pBlkLast->Size  = 0;
	pBlkLast->iFlag = VALMEMHEAP_USING;
}


/* end of file */
