/** 
 *  Hyper Operating System  Application Framework
 *
 * @file  valmemheap_free.c
 * @brief %jp{ѥҡץ饹}%en{variable size memory heap class}
 *
 * Copyright (C) 2006-2008 by Project HOS
 * http://sourceforge.jp/projects/hos/
 */


#include <stdio.h>
#include "valmemheap_local.h"



/** Υ */
MEMSIZE	ValMemHeap_GetSize(void *pMemHeap, void *pMem)
{
	C_VALMEMHEAP		*self;
	T_VALMEMHEAP_MEMBLK *mblk;
	MEMSIZE				MemBlockSize;
	
	/* upper cast */
	self = (C_VALMEMHEAP *)pMemHeap;

	/* %jp{֥åΥĴ} */
	MemBlockSize = ValMemHeap_GetMemBlockSize(self);

	/* %jp{ݥϰϥå} */
	if ( pMem < (void *)self->pMemBase || pMem >= (void *)((char *)self->pMemBase + self->MemSize) )
	{
		return 0;	/* %jp{Υסν°Ǥʤ} */
	}
	
	/* %jp{֥å֤} */
	mblk = (T_VALMEMHEAP_MEMBLK *)((char *)pMem - MemBlockSize);
	
	/* %jp{ѥ᡼å} */
	if ( mblk->iFlag != VALMEMHEAP_USING )	/* %jp{̵} */
	{
		return 0;	/* %jp{Ƥʤ} */
	}
	
	/* %jp{֤} */
	return mblk->Size;
}


/* end of file */
