# ----------------------------------------------------------------------------
# Hyper Operating System V4 Advance
#
# Copyright (C) 1998-2007 by Project HOS
# http://sourceforge.jp/projects/hos/
# ----------------------------------------------------------------------------


# %jp{å̾}
TARGET ?= sample

# %jp{ġ}
GCC_ARCH   ?= arm-elf-
CMD_CC     ?= $(GCC_ARCH)gcc
CMD_ASM    ?= $(GCC_ARCH)gcc
CMD_LINK   ?= $(GCC_ARCH)gcc
CMD_OBJCNV ?= $(GCC_ARCH)objcopy


# %jp{ǥ쥯ȥ}
OS_DIR            = ../../../../..
KERNEL_DIR        = $(OS_DIR)/kernel
KERNEL_CFGRTR_DIR = $(OS_DIR)/cfgrtr/build/gcc
KERNEL_MAKINC_DIR = $(KERNEL_DIR)/build/common/gmake
KERNEL_BUILD_DIR  = $(KERNEL_DIR)/build/arm/at91/gcc
APLFW_DIR         = $(OS_DIR)/aplfw
APLFW_INC_DIR     = $(APLFW_DIR)
APLFW_BUILD_DIR   = $(APLFW_DIR)/build/arm/arm_v4t/gcc
OBJS_DIR          = objs_$(TARGET)


# %jp{ɹ}
include $(KERNEL_MAKINC_DIR)/common.inc


# %jp{ե졼}
KERNEL_CFGRTR = $(KERNEL_CFGRTR_DIR)/h4acfg-at91


# %jp{饤֥}
APLFW_LIB = $(APLFW_BUILD_DIR)/hosaplfw.a


# %jp{ǥХåǤѹ}
ifeq ($(DEBUG),Yes)
TARGET := $(TARGET)dbg
APLFW_LIB = $(APLFW_BUILD_DIR)/hosaplfwdbg.a
endif


# %jp{ޥå}
ifeq ($(MEMMAP),ext)
# %jp{}
TARGET       := $(TARGET)ext
LINK_SCRIPT = linkext.x
else
ifeq ($(MEMMAP),ram)
# %jp{¢RAM}
TARGET       := $(TARGET)ram
LINK_SCRIPT = linkram.x
else
# %jp{¢ROM}
LINK_SCRIPT = link.x
endif
endif


# %jp{ե饰}
CFLAGS  = -mcpu=arm7tdmi -mthumb-interwork
AFLAGS  = -mcpu=arm7tdmi -mthumb-interwork
LNFLAGS = -mcpu=arm7tdmi -mthumb-interwork -nostartfiles -Wl,-Map,$(TARGET).map,-T$(LINK_SCRIPT)


# %jp{ϥե̾}
TARGET_EXE = $(TARGET).elf
TARGET_MOT = $(TARGET).mot
TARGET_HEX = $(TARGET).hex


# %jp{gccѤɹ}
include $(KERNEL_MAKINC_DIR)/gcc_d.inc


# %jp{󥯥롼ɥǥ쥯ȥ}
INC_DIRS += $(APLFW_INC_DIR)

# %jp{ǥ쥯ȥ}
SRC_DIRS += . ..


# %jp{֥եɲ}
ASRCS += ./vectors.S		\
         ./crt0.S


# %jp{Cեɲ}
CSRCS += ../kernel_cfg.c	\
         ../main.c			\
         ../boot.c			\
         ../ostimer.c

# %jp{饤֥եɲ}
LIBS += $(APLFW_LIB)



# --------------------------------------
#  %jp{롼}
# --------------------------------------

.PHONY : all
all: aplfw_make makeexe_all $(TARGET_EXE) $(TARGET_MOT) $(TARGET_HEX)


.PHONY : aplfw_make
aplfw_make:
	$(MAKE) -C $(APLFW_BUILD_DIR) -f gmake.mak

.PHONY : clean
clean: makeexe_clean
	rm -f $(TARGET_EXE) $(TARGET_EXE) $(OBJS) ../kernel_cfg.c ../kernel_id.h

.PHONY : mostlyclean
mostlyclean: clean kernel_clean
	$(MAKE) -C $(APLFW_BUILD_DIR) -f gmake.mak clean

.PHONY : mostlydepend
mostlydepend: depend kernel_depend
	$(MAKE) -C $(APLFW_BUILD_DIR) -f gmake.mak depend


../kernel_cfg.c ../kernel_id.h: ../system.cfg
	cpp -E ../system.cfg ../system.i
	$(KERNEL_CFGRTR) ../system.i -c ../kernel_cfg.c -i ../kernel_id.h



# %jp{饤֥ɹ}
include $(KERNEL_MAKINC_DIR)/makeexe.inc

# %jp{gccѤΥ롼ɹ}
include $(KERNEL_MAKINC_DIR)/gcc_r.inc



# --------------------------------------
#  %jp{¸ط}
# --------------------------------------

$(OBJS_DIR)/sample.obj: ../sample.c ../kernel_id.h


# end of file
