/** 
 *  Sample program for Hyper Operating System V4 Advance
 *
 * @file  ostimer.c
 * @brief %jp{OS}%en{OS timer}
 *
 * Copyright (C) 1998-2008 by Project HOS
 * http://sourceforge.jp/projects/hos/
 */


#include "hosaplfw.h"
#include "system/sysapi/sysapi.h"
#include "ostimer.h"


#define TIMER0_CONTROL	((volatile unsigned long *)0xf1000000)
#define TIMER0_COMPARE	((volatile unsigned long *)0xf1000004)
#define TIMER0_COUNTER	((volatile unsigned long *)0xf100000c)

#define INTNO_TIMER0	0



static void OsTimer_Isr(VPARAM Param);		/**< %jp{޳ߥӥ롼} */


/** %jp{OSѥ޽롼} */
void OsTimer_Initialize(void)
{
	/* %jp{ߥӥ롼} */
	SysIsr_Create(INTNO_TIMER0, OsTimer_Isr, (VPARAM)0);
	
	/* %jp{} */
	*TIMER0_COMPARE = (50000 - 1);		/* 50Mhz / 50000 = 1kHz (1ms) */
	*TIMER0_CONTROL = 0x0002;			/* clear */
	*TIMER0_CONTROL = 0x0001;			/* start */
	
	/* %jp{ߵ} */
	SysInt_Enable(INTNO_TIMER0);
}


/** %jp{޳ߥϥɥ} */
void OsTimer_Isr(VPARAM Param)
{
	/* %jp{װꥢ} */
	SysInt_Clear(INTNO_TIMER0);
	
	/* %jp{ƥå} */
	SysTim_Signal(1000000);		/* 1ms = 1,000,000 ns */
}


/** ƥʥä˴(ƥ) */
unsigned long SysTim_SysTimeToNanosecond(SYSTIM_SYSTIME SysTime)
{
	return (unsigned long)(SysTime % 1000000000);
}

/* ƥä˴(ƥ) */
unsigned long  SysTim_SysTimeToSecond(SYSTIM_SYSTIME SysTime)
{
	return (unsigned long)(SysTime / 1000000000);
}






/* end of file */

