# ----------------------------------------------------------------------------
# Hyper Operating System V4 Advance
#  makefile for sh2-sample
#
# Copyright (C) 1998-2006 by Project HOS
# http://sourceforge.jp/projects/hos/
# ----------------------------------------------------------------------------

# %jp{å̾}
TARGET ?= sample

# %jp{ġ}
GCC_ARCH   ?= sh-elf-
CMD_CC     ?= $(GCC_ARCH)gcc
CMD_ASM    ?= $(GCC_ARCH)gcc
CMD_LINK   ?= $(GCC_ARCH)gcc
CMD_OBJCNV ?= $(GCC_ARCH)objcopy


# %jp{ǥ쥯ȥ}
TOP_DIR            = ../../../../..
KERNEL_DIR         = $(TOP_DIR)/kernel
KERNEL_CFGRTR_DIR  = $(TOP_DIR)/cfgrtr/build/gcc
KERNEL_MAKINC_DIR  = $(KERNEL_DIR)/build/common/gmake
KERNEL_BUILD_DIR   = $(KERNEL_DIR)/build/sh/sh2/gcc
HOSAPLFW_DIR       = $(TOP_DIR)/aplfw
HOSAPLFW_INC_DIR   = $(HOSAPLFW_DIR)
HOSAPLFW_BUILD_DIR = $(HOSAPLFW_DIR)/build/sh/sh2/gcc
OBJS_DIR           = objs_$(TARGET)


# %jp{ͥեå}
KERNEL_HOK_TSK = Yes
KERNEL_HOK_ISR = Yes


# %jp{ɹ}
include $(KERNEL_MAKINC_DIR)/common.inc


# %jp{ե졼}
KERNEL_CFGRTR = $(KERNEL_CFGRTR_DIR)/h4acfg-sh2


# %jp{饤֥}
HOSAPLFW_LIB = $(HOSAPLFW_BUILD_DIR)/hosaplfw.$(EXT_LIB)


# %jp{ޥå}
ifeq ($(MEMMAP),ext)
# %jp{(˥ץѤ)}
TARGET     := $(TARGET)ext
LINK_SCRIPT = link_ext.x
else
# %jp{ROM¹}
LINK_SCRIPT = link_rom.x
endif


# %jp{ǥХåǤѹ}
ifeq ($(DEBUG),Yes)
TARGET := $(TARGET)dbg
HOSAPLFW_LIB = $(HOSAPLFW_BUILD_DIR)/hosaplfwdbg.$(EXT_LIB)
endif


# %jp{ե饰}
CFLAGS  = -m2
AFLAGS  = -m2
LNFLAGS = -m2 -nostartfiles -Wl,-Map,$(TARGET).map,-T$(LINK_SCRIPT)


# %jp{ϥե̾}
TARGET_EXE = $(TARGET).$(EXT_EXE)
TARGET_MOT = $(TARGET).$(EXT_MOT)


# %jp{gccѤɹ}
include $(KERNEL_MAKINC_DIR)/gcc_d.inc


# %jp{󥯥롼ɥǥ쥯ȥ}
INC_DIRS += $(HOSAPLFW_INC_DIR)


# %jp{ǥ쥯ȥ}
SRC_DIRS += . ..


# %jp{֥եɲ}
ASRCS += ./vector.S			\
         ./crt0.S

# %jp{Cեɲ}
CSRCS += ../kernel_cfg.c	\
         ../main.c			\
         ../boot.c			\
         ../ostimer.c

# %jp{饤֥ɲ}
LIBS  += $(HOSAPLFW_LIB)



# --------------------------------------
#  %jp{롼}
# --------------------------------------

.PHONY : all
all: kernel_make make_subprj makeexe_all $(TARGET_EXE) $(TARGET_MOT)

.PHONY : make_subprj
make_subprj:
	$(MAKE) -C $(HOSAPLFW_BUILD_DIR) -f gmake.mak

.PHONY : clean
clean: makeexe_clean
	rm -f $(TARGET_EXE) $(TARGET_EXE) $(OBJS) ../kernel_cfg.c ../kernel_id.h

.PHONY : mostlyclean
mostlyclean: clean kernel_clean
	$(MAKE) -C $(HOSAPLFW_BUILD_DIR) -f gmake.mak clean

.PHONY : depend
depend: makeexe_depend

.PHONY : mostlydepend
mostlydepend: depend kernel_depend
	$(MAKE) -C $(HOSAPLFW_BUILD_DIR) -f gmake.mak depend

.PHONY : srccpy
srccpy: makeexe_srccpy
	$(MAKE) -C $(KERNEL_BUILD_DIR) -f gmake.mak srccpy
	$(MAKE) -C $(HOSAPLFW_BUILD_DIR) -f gmake.mak srccpy

../kernel_cfg.c ../kernel_id.h: ../system.cfg $(KERNEL_CFGRTR)
	cpp -E ../system.cfg ../system.i
	$(KERNEL_CFGRTR) ../system.i -c ../kernel_cfg.c -i ../kernel_id.h

$(KERNEL_CFGRTR) : kernel_make


# %jp{饤֥ɹ}
include $(KERNEL_MAKINC_DIR)/makeexe.inc


# %jp{shcѤΥ롼ɹ}
include $(KERNEL_MAKINC_DIR)/gcc_r.inc



# --------------------------------------
#  %jp{¸ط}
# --------------------------------------

$(OBJS_DIR)/sample.$(EXT_OBJ): ../sample.c ../kernel_id.h


# end of file

