# ----------------------------------------------------------------------------
# Hyper Operating System  Application Framework
#
# Copyright (C) 2007-2008 by Project HOS
# http://sourceforge.jp/projects/hos/
# ----------------------------------------------------------------------------


# %jp{å̾}
TARGET ?= sample

# %jp{ǥ쥯ȥ}
TOP_DIR             = ../../../../..
KERNEL_DIR          = $(TOP_DIR)/kernel
KERNEL_CFGRTR_DIR   = $(TOP_DIR)/cfgrtr/build/gcc
KERNEL_MAKINC_DIR   = $(KERNEL_DIR)/build/common/gmake
KERNEL_BUILD_DIR    = $(KERNEL_DIR)/build/sh/sh2/shc
HOSAPLFW_DIR        = $(TOP_DIR)/aplfw
HOSAPLFW_INC_DIR    = $(HOSAPLFW_DIR)
HOSAPLFW_BUILD_DIR  = $(HOSAPLFW_DIR)/build/sh/sh2/shc
OBJS_DIR            = objs_$(TARGET)


# %jp{ɹ}
include $(KERNEL_MAKINC_DIR)/common.inc


# %jp{ե졼}
KERNEL_CFGRTR = $(KERNEL_CFGRTR_DIR)/h4acfg-sh2


# %jp{饤֥}
HOSAPLFW_LIB = $(HOSAPLFW_BUILD_DIR)/hosaplfw.$(EXT_LIB)
STD_LIBS  = stdlib.lib


# %jp{ޥå}
ifeq ($(MEMMAP),ext)
# %jp{}
TARGET       := $(TARGET)ext
SECTION_VECT ?= 00400000
SECTION_ROM  ?= 00400400
SECTION_RAM  ?= 00410000
else
# %jp{¢ROM}
SECTION_VECT ?= 00000000
SECTION_ROM  ?= 00000400
SECTION_RAM  ?= 00400000
endif


# %jp{ǥХåǤѹ}
ifeq ($(DEBUG),Yes)
TARGET := $(TARGET)dbg
HOSAPLFW_LIB = $(HOSAPLFW_BUILD_DIR)/hosaplfwdbg.$(EXT_LIB)
endif


# %jp{ե饰}
CFLAGS  += -CP=sh2 -DEBug -NOLOGO
AFLAGS  += -CP=sh2 -DEBug -NOLOGO
LNFLAGS += 


# %jp{ϥե̾}
TARGET_EXE = $(TARGET).$(EXT_EXE)
TARGET_MOT = $(TARGET).$(EXT_MOT)


# %jp{shcѤɹ}
include $(KERNEL_MAKINC_DIR)/shc_d.inc


# %jp{󥯥롼ɥǥ쥯ȥ}
INC_DIRS += $(HOSAPLFW_INC_DIR)

# %jp{ǥ쥯ȥ}
SRC_DIRS += . ..


# %jp{֥եɲ}
ASRCS += ./vcttbl.src		\
         ./startup.src		\


# %jp{Cեɲ}
CSRCS += ./dbsct.c			\
         ../kernel_cfg.c	\
         ../main.c			\
         ../boot.c			\
         ../ostimer.c


# %jp{饤֥եɲ}
LIBS += $(HOSAPLFW_LIB) $(STD_LIBS)



# --------------------------------------
#  %jp{롼}
# --------------------------------------

.PHONY : all
all: make_libs makeexe_all $(TARGET_EXE) $(TARGET_MOT)


.PHONY : make_libs
make_libs:
	$(MAKE) -C $(HOSAPLFW_BUILD_DIR) -f gmake.mak

.PHONY : clean
clean: makeexe_clean
	rm -f $(TARGET_EXE) $(TARGET_EXE) $(OBJS) ../kernel_cfg.c ../kernel_id.h

.PHONY : mostlyclean
mostlyclean: clean kernel_clean
	$(MAKE) -C $(HOSAPLFW_BUILD_DIR) -f gmake.mak clean

.PHONY : depend
depend: makeexe_depend

.PHONY : mostlydepend
mostlydepend: depend kernel_depend
	$(MAKE) -C $(HOSAPLFW_BUILD_DIR) -f gmake.mak depend

.PHONY : srccpy
srccpy: makeexe_srccpy
	$(MAKE) -C $(KERNEL_BUILD_DIR) -f gmake.mak srccpy
	$(MAKE) -C $(HOSAPLFW_BUILD_DIR) -f gmake.mak srccpy


$(STD_LIBS):
	lbgsh -OUTPut=$(STD_LIBS) -CP=sh2
#	lbgsh -OUTPut=$(STD_LIBS) -CP=sh2 -REent 


../kernel_cfg.c ../kernel_id.h: ../system.cfg
	cpp -E ../system.cfg ../system.i
	$(KERNEL_CFGRTR) ../system.i -c ../kernel_cfg.c -i ../kernel_id.h



# %jp{饤֥ɹ}
include $(KERNEL_MAKINC_DIR)/makeexe.inc

# %jp{shcѤΥ롼ɹ}
include $(KERNEL_MAKINC_DIR)/shc_r.inc



# --------------------------------------
#  %jp{¸ط}
# --------------------------------------

$(OBJS_DIR)/sample.obj: ../sample.c ../kernel_id.h


# end of file
