/** 
 *  Hyper Operating System  Application Framework
 *
 * @file  fileobj.h
 * @brief %jp{ե륪֥}
 *
 * %jp{եǥץȤƵǽ륯饹}
 *
 * Copyright (C) 2006-2007 by Project HOS
 * http://sourceforge.jp/projects/hos/
 */


#ifndef __HOS__fileobj_h__
#define __HOS__fileobj_h__


#include "system/file/file.h"
#include "system/handle/handleobj.h"

struct c_drvobj;

/* ե륪֥ȥ饹ܥ᥽åɥơ֥ */
typedef struct t_fileobj_methods
{
	T_HANDLEOBJ_METHODS	HandlObjMethods;	/* ϥɥ륪֥ȤѾ */
} T_FILEOBJ_METHODS;


/* ե֥ȴܥ饹 */
typedef struct c_fileobj
{
	C_HANDLEOBJ		HandleObj;				/* ϥɥ륪֥ȤѾ */

	struct c_drvobj	*pDrvObj;				/* ɥ饤Фؤλ */

	int				iMode;					/* ץΥ⡼ */
	void			*pReadBuf;				/* ꡼ɥХåե */
	void			*pWriteBuf;				/* 饤ȥХåե */	
} C_FILEOBJ;


#include "drvobj.h"


/* ϥɥѴ */
#define FILE_HANDLE2OBJ(hFile)		((C_FILEOBJ *)(hFile))


#ifdef __cplusplus
extern "C" {
#endif

HANDLE FileObj_Create(struct c_drvobj *pDrvObj, int iMode);
void   FileObj_Delete(HANDLE Handle);

#define FileObj_GetMode(self)		((self)->iMode)

#ifdef __cplusplus
}
#endif




#endif	/* __HOS__file_h__ */


/* end of file */
