/** 
 *  Hyper Operating System  Application Framework
 *
 * @file  syncfile.h
 * @brief %jp{ƱǽդǥХɥ饤ѥեǥץ}
 *
 * %jp{եǥץȤƵǽ륯饹}
 *
 * Copyright (C) 2006-2007 by Project HOS
 * http://sourceforge.jp/projects/hos/
 */



#include "syncfile_local.h"


FILE_ERR SyncFile_Constructor(C_SYNCFILE *self, const T_FILEOBJ_METHODS *pMethods, struct c_syncdrv *pSyncDrv, int iMode)
{
	int iFactorNum;
	int i;
	
	/* Ʊװ */
	iFactorNum = SyncDrv_GetSyncFactorNum(pSyncDrv);
	
	/*  */
	if ( (self->pSyncObj = (T_SYNCFILE_SYNCOBJ *)SysMem_Alloc(sizeof(T_SYNCFILE_SYNCOBJ) * iFactorNum)) == NULL )
	{
		return FILE_ERR_NG;
	}

	/* ƥ饹󥹥ȥ饯ƤӽФ */
	FileObj_Constructor(&self->FileObj, pMethods, &pSyncDrv->DrvObj, iMode);
	
	/* н */
	for ( i = 0; i < iFactorNum; i++ )
	{
		self->pSyncObj[i].Mode     = FILE_SYNCMODE_BLOCKING;
		self->pSyncObj[i].hEvt     = SysEvt_Create(SYSEVT_ATTR_NORMAL);
		self->pSyncObj[i].ErrCode  = FILE_ERR_OK;
		self->pSyncObj[i].Inf.Type = FILE_SYNCTYPE_NONE;
	}
	
	/* ꥹϢ */
	SysMtx_Lock(pSyncDrv->hMtx);
	if ( pSyncDrv->pFileHead == NULL )
	{
		self->pNext        = self;	
		self->pPrev        = self;
		pSyncDrv->pFileHead = self;
	}
	else
	{
		self->pNext = pSyncDrv->pFileHead;	
		self->pPrev = self->pNext->pPrev;
		self->pNext->pPrev = self;
		self->pPrev->pNext = self;
	}
	SysMtx_Unlock(pSyncDrv->hMtx);
	
	return FILE_ERR_OK;
}


/* end of file */
