/** 
 *  Hyper Operating System  Application Framework
 *
 * @file  syncfile.h
 * @brief %jp{ƱǽդǥХɥ饤ѥեǥץ}
 *
 * %jp{եǥץȤƵǽ륯饹}
 *
 * Copyright (C) 2006-2007 by Project HOS
 * http://sourceforge.jp/projects/hos/
 */



#include "syncfile_local.h"


void SyncFile_Destructor(C_SYNCFILE *self)
{
	C_SYNCDRV	*pSyncDrv;
	int			iFactorNum;
	int			i;

	pSyncDrv = (C_SYNCDRV *)self->FileObj.pDrvObj;

	/* Ʊװ */
	iFactorNum = SyncDrv_GetSyncFactorNum(pSyncDrv);
	
	/* ꥹϢ */
	SysMtx_Lock(pSyncDrv->hMtx);
	if ( self->pNext == self )
	{
		pSyncDrv->pFileHead = NULL;
	}
	else
	{
		if ( pSyncDrv->pFileHead == self )
		{
			pSyncDrv->pFileHead = self->pNext;
		}
		self->pNext->pPrev = self->pPrev;
		self->pPrev->pNext = self->pNext;
	}
	SysMtx_Unlock(pSyncDrv->hMtx);	
	
	
	/* ֥Ⱥ */
	for ( i = 0; i < iFactorNum; i++ )
	{
		SysEvt_Delete(self->pSyncObj[i].hEvt);
	}

	/* 곫 */
	SysMem_Free(self->pSyncObj);
	
	/* ƥ饹ǥȥ饯ƤӽФ */
	FileObj_Destructor(&self->FileObj);
}


/* end of file */
