/** 
 *  Hyper Operating System  Application Framework
 *
 * @file  syncfile.h
 * @brief %jp{ƱǽդǥХɥ饤ѥեǥץ}
 *
 * %jp{եǥץȤƵǽ륯饹}
 *
 * Copyright (C) 2006-2007 by Project HOS
 * http://sourceforge.jp/projects/hos/
 */


#ifndef __HOS__syncfile_local_h__
#define __HOS__syncfile_local_h__

#include "syncfile.h"
#include "system/file/fileobj_local.h"
#include "system/file/syncdrv_local.h"
#include "system/sysapi/sysapi.h"


/* Ʊ֥ */
typedef struct t_syncfile_syncobj
{
	int					Mode;			/**< Ʊ⡼ */
	VPARAM				ErrCode;		/**< 顼 */
	SYSEVT_HANDLE		hEvt;			/**< Ʊ٥ */
	T_FILE_SYNCINF		Inf;			/**< Ʊ */
} T_SYNCFILE_SYNCOBJ;


/* ե֥ȴܥ饹 */
typedef struct c_syncfile
{
	C_FILEOBJ			FileObj;		/**< ե륪֥ȤѾ */
	
	struct c_syncfile	*pNext;			/**< ٥ȴƻꥹϢ */
	struct c_syncfile	*pPrev;			/**< ٥ȴƻꥹϢ */

	T_SYNCFILE_SYNCOBJ	*pSyncObj;		/**< Ʊ֥ */
} C_SYNCFILE;


#ifdef __cplusplus
extern "C" {
#endif

FILE_ERR SyncFile_Constructor(C_SYNCFILE *self, const T_FILEOBJ_METHODS *pMethods, struct c_syncdrv *pSyncDrv, int iMode);
void     SyncFile_Destructor(C_SYNCFILE *self);

void     SyncFile_SetSignal(C_SYNCFILE *self, int iFactor);															/**< ʥΥå */
#define  SyncFile_ClearSignal(self, iFactor)		do { SysEvt_Clear((self)->pSyncObj[iFactor].hEvt); } while(0)	/**< ʥΥꥢ */
#define  SyncFile_WaitSignal(self, iFactor)			do { SysEvt_Wait((self)->pSyncObj[iFactor].hEvt); } while(0)	/**< ʥԤ */
#define  SyncFile_RefSignal(self, iFactor)			(SysEvt_RefStatus((self)->pSyncObj[iFactor].hEvt))				/**< ʥξֻ */

#define  SyncFile_SetSyncMode(self, iFactor, x)		do { ((self)->pSyncObj[iFactor].Mode) = (x); } while(0)			/**< Ʊ⡼ */
#define  SyncFile_GetSyncMode(self, iFactor)		((self)->pSyncObj[iFactor].Mode)								/**< Ʊ⡼ɼ */

#define  SyncFile_SetSyncInf(self, iFactor, x)		do { ((self)->pSyncObj[iFactor].Inf) = (x); } while(0)			/**< Ʊ */
#define  SyncFile_GetSyncInf(self, iFactor)			((self)->pSyncObj[iFactor].Inf)									/**< Ʊ */

#define  SyncFile_SetErrCode(self, iFactor, x)		do { ((self)->pSyncObj[iFactor].ErrCode) = (x); } while(0)		/**< 顼 */
#define  SyncFile_GetErrCode(self, iFactor)			((self)->pSyncObj[iFactor].ErrCode)								/**< 顼ɼ */

#ifdef __cplusplus
}
#endif


#endif	/* __HOS__syncfile_h__ */


/* end of file */
