/** 
 *  Hyper Operating System  Application Framework
 *
 * @file  syncfile.h
 * @brief %jp{ƱǽդǥХɥ饤ѥեǥץ}
 *
 * %jp{եǥץȤƵǽ륯饹}
 *
 * Copyright (C) 2006-2007 by Project HOS
 * http://sourceforge.jp/projects/hos/
 */



#include "hosaplfw.h"
#include "syncdrv_local.h"
#include "system/system/system.h"



/** ʥΥå */
void SyncFile_SetSignal(C_SYNCFILE *self, int iSignal)
{
	/* ٥ */
	SysEvt_Set(self->pSyncObj[iSignal].hEvt);
	
	/* Υפ˱μ» */
	switch ( self->pSyncObj[iSignal].Inf.Type )
	{
	case FILE_SYNCTYPE_EVENT:		/* ٥ */
		Event_Set(self->pSyncObj[iSignal].Inf.Sync.hEvent);
		break;
		
	case FILE_SYNCTYPE_CALLBACK:	/* Хå */
		self->pSyncObj[iSignal].Inf.Sync.Proc.pfncProc(self->pSyncObj[iSignal].Inf.Sync.Proc.Param, self->pSyncObj[iSignal].ErrCode);
		break;
	}
}


/* end of file */
