/** 
 *  Hyper Operating System  Application Framework
 *
 * @file  sysvol.h
 * @brief %jp{ƥܥ塼}
 *
 *  %jp{롼ȥǥ쥯ȥ /dev ǥ쥯ȥʤɡƥβۥܥ塼}
 *
 * Copyright (C) 2006-2007 by Project HOS
 * http://sourceforge.jp/projects/hos/
 */


#ifndef __HOS__sysvol_h__
#define __HOS__sysvol_h__


#include "system/file/file.h"
#include "system/file/volumeobj.h"


#define DEVVOL_MAX_DEVICE		16
#define DEVVOL_MAX_NAME			16

/* ǥХ */
struct c_drvobj;
typedef struct t_sysvol_devinf
{
	char			szName[DEVVOL_MAX_NAME];		/* ǥХ̾ */
	HANDLE			hDriver;						/* ǥХɥ饤ФΥϥɥ */
	int				iAttr;							/* ǥХ° */
} T_SYSVOL_DEVINF;


/* ƥܥ塼९饹 */
typedef struct c_sysvol
{
	C_VOLUMEOBJ		VolumeObj;		/* ܥ塼४֥ȤѾ */
	
	T_SYSVOL_DEVINF DevTable[DEVVOL_MAX_DEVICE];
} C_SYSVOL;


#ifdef __cplusplus
extern "C" {
#endif

HANDLE   SysVol_Create(void);
void     SysVol_Delete(HANDLE hVolume);

FILE_ERR SysVol_AddDevice(HANDLE hSysVol, const char *pszName, HANDLE hDriver, int iAttr);	/* ƥܥ塼˥ǥХϿ */
FILE_ERR SysVol_RemoveDevice(HANDLE hSysVol, const char *pszName);							/* ƥܥ塼Ͽ줿ǥХ곰 */
HANDLE   SysVol_GetDevice(HANDLE hSysVol, const char *pszName);								/* ƥܥ塼Ͽ줿ǥХ򸡺 */


#ifdef __cplusplus
}
#endif

#endif	/* __HOS__sysvol_h__ */



/* end of file */
