/** 
 *  Hyper Operating System  Application Framework
 *
 * @file  volumeobj.h
 * @brief %jp{ܥ塼४֥ȴܥ饹}
 *
 * Copyright (C) 2006 by Project HOS
 * http://sourceforge.jp/projects/hos/
 */


#ifndef __HOS__volumeobj_h__
#define __HOS__volumeobj_h__


#include "system/handle/handleobj.h"
#include "system/file/drvobj.h"


/* ܥ塼֥ȥ饹ܥ᥽åɥơ֥ */
struct c_volumeobj;
typedef struct t_volumeobj_methods
{
	T_DRVOBJ_METHODS	DrvObjMethods;			/* DrvObjѾ */

	FILE_ERR (*pfncShutdown)(struct c_volumeobj *self);							/* ǥХΥåȥ */
	FILE_ERR (*pfncMakeDir)(struct c_volumeobj *self, const char *pszPath);		/* ֥ǥ쥯ȥ */
	FILE_ERR (*pfncRemove)(struct c_volumeobj *self, const char *pszPath);		/* ե */
} T_VOLUMEOBJ_METHODS;

typedef struct c_volumeobj
{
	C_DRVOBJ	DrvObj;							/* DrvObjѾ */
} C_VOLUMEOBJ;


/* ϥɥѴ */
#define VOLUME_HANDLE2OBJ(hVolume)		((C_VOLUMEOBJ *)hVolume)


#ifdef __cplusplus
extern "C" {
#endif

HANDLE   VolumeObj_Create(void);												/**<  */
void     VolumeObj_Delete(HANDLE hVolume);										/**<  */

FILE_ERR VolumeObj_Shutdown(C_VOLUMEOBJ *self);									/**< åȥ */
FILE_ERR VolumeObj_MakeDir(C_VOLUMEOBJ *self, const char *pszPath);				/**< ֥ǥ쥯ȥ */
FILE_ERR VolumeObj_Remove(C_VOLUMEOBJ *self, const char *pszPath);				/**< ե */

#ifdef __cplusplus
}
#endif

#define VolumeObj_GetMethods(self)		((T_VOLUMEOBJ_METHODS *)HandleObj_GetMethods(&(self)->DrvObj))



#endif	/* __HOS__volumeobj_h__ */


/* end of file */
