/** 
 *  Hyper Operating System  Application Framework
 *
 * @file  process.h
 * @brief %jp{ץ֥}
 *
 * Copyright (C) 2006-2008 by Project HOS
 * http://sourceforge.jp/projects/hos/
 */


#ifndef __HOS__process_h__
#define __HOS__process_h__


#include "system/type/type.h"
#include "system/handle/handle.h"
#include "system/file/file.h"
#include "system/file/console.h"
#include "library/container/assoc/assoc.h"


/* (ȤꤢŬΤTSSȤܤˤȤΰ٤ˤҤȤޤ) */
#define PROCESS_PRIORITY_IDLE		50
#define PROCESS_PRIORITY_LOW		40
#define PROCESS_PRIORITY_NORMAL		30
#define PROCESS_PRIORITY_HIGH		20
#define PROCESS_PRIORITY_REALTIME	10

#define PROCESS_SIGNAL_HUP			1
#define PROCESS_SIGNAL_KILL			9


#define PROCESS_ERR_OK				0
#define PROCESS_ERR_NG				(-1)

typedef int		PROCESS_ERR;


/* ץ */
typedef struct t_process_create_inf
{
	const char	*pszCommandLine;					/**< ޥɥ饤 */
	const char	*pszCurrentDir;						/**< ưǥ쥯ȥ */
	int			(*pfncEntry)(VPARAM Param);			/**< ưɥ쥹 */
	VPARAM		Param;								/**< 桼ѥ᡼ */
	MEMSIZE		StackSize;							/**< å */
	int			Priority;							/**< ץͥ */
	HANDLE		hTerminal;							/**< ߥʥ */
	HANDLE		hConIn;								/**< 󥽡 */
	HANDLE		hConOut;							/**< 󥽡 */
	HANDLE		hStdIn;								/**< ɸ */
	HANDLE		hStdOut;							/**< ɸ */
	HANDLE		hStdErr;							/**< ɸ२顼 */
} T_PROCESS_CREATE_INF;



#ifdef __cplusplus
extern "C" {
#endif

HANDLE        Process_Create(const char *pszCommand, MEMSIZE StackSize, int Priority);			/**< ץ */
HANDLE        Process_CreateEx(const T_PROCESS_CREATE_INF *pInf);								/**< ץ(ܺ) */
void          Process_Delete(HANDLE hProcess);													/**< ץ */

HANDLE        Process_GetCurrentHandle(void);													/**< ߤΥץϥɥ */	
void          Process_Exit(int iExitCode);														/**< ߤΥץλ */

int           Process_IsExit(HANDLE hProcess);													/**< ץνλǧ */
int           Process_WaitExit(HANDLE hProcess);												/**< ץνλԤ */
int           Process_GetExitCode(HANDLE hProcess);												/**< ץνλɼ */

void          Process_SetSignalProc(HANDLE hProcess, void (*pfncSignalProc)(int iSignal));		/**< ץ˥ʥץϿ */
void          Process_SendSignal(HANDLE hProcess, int iSignal);									/**< ץ˥ʥ */

PROCESS_ERR   Process_EnterSystemMode(void);													/**< ƥ⡼ɤ */
void          Process_LeaveSystemMode(void);													/**< ƥ⡼ɤФ */
int           Process_IsSystemMode(void);														/**< ƥ⡼ɤɤ䤤碌 */

const char    *Process_GetCommandLine(HANDLE hProcess);											/**< ޥɥ饤μ */	
unsigned long Process_GetExecutionTime(HANDLE hProcess, unsigned long *pulNanosecond);			/**< ¹Ի֤μ */	
HANDLE        Process_GetParentProcess(HANDLE hProcess);										/**< ƥץμ */

void          Process_SetParam(HANDLE hProcess, VPARAM Param);									/**< ץͭ */
VPARAM        Process_GetParam(HANDLE hProcess);												/**< ץͭμ */

void          Process_SetEnvString(HANDLE hProcess, const char *pszKey, const char *pszValue);	/**< Ķѿ */
const char    *Process_GetEnvString(HANDLE hProcess, const char *pszKey);						/**< Ķѿ */

int           Process_SetCurrentDir(HANDLE hProcess, const char *pszPath);						/**< ץΥȥǥ쥯ȥ */
const char    *Process_GetCurrentDir(HANDLE hProcess);											/**< ץΥȥǥ쥯ȥ */

void          Process_SetTerminal(HANDLE hProcess, HANDLE hFile);								/**< ץɸॿߥʥ */
HANDLE        Process_GetTerminal(HANDLE hProcess);												/**< ץɸॿߥʥ */
void          Process_SetConIn(HANDLE hProcess, HANDLE hFile);									/**< ץɸॳ󥽡 */
HANDLE        Process_GetConIn(HANDLE hProcess);				 								/**< ץɸॳ󥽡 */
void          Process_SetConOut(HANDLE hProcess, HANDLE hFile);									/**< ץɸॳ󥽡 */
HANDLE        Process_GetConOut(HANDLE hProcess);				 								/**< ץɸॳ󥽡 */
void          Process_SetStdIn(HANDLE hProcess, HANDLE hFile);									/**< ץɸ */
HANDLE        Process_GetStdIn(HANDLE hProcess);			   									/**< ץɸϼ */
void          Process_SetStdOut(HANDLE hProcess, HANDLE hFile);									/**< ץɸ */
HANDLE        Process_GetStdOut(HANDLE hProcess);												/**< ץɸϼ */
void          Process_SetStdErr(HANDLE hProcess, HANDLE hFile);									/**< ץɸ२顼 */
HANDLE        Process_GetStdErr(HANDLE hProcess);												/**< ץɸ२顼ϼ */


#ifdef __cplusplus
}
#endif


#endif	/* __HOS__process_h__ */


/* end of file */
