/** 
 *  Hyper Operating System  Application Framework
 *
 * @file  process.c
 * @brief %jp{ץ֥}
 *
 * Copyright (C) 2006-2007 by Project HOS
 * http://sourceforge.jp/projects/hos/
 */


#include "process_local.h"


/** Ķѿ */
const char *Process_GetEnvString(HANDLE hProcess, const char *pszKey)
{
	const char	*pszValue = NULL;
	C_PROCESS	*self;
	HANDLE		hParent;
	
	/* ̵꤬иߤΥץȤ */
	if ( hProcess == HANDLE_NULL )
	{
		hProcess = Process_GetCurrentHandle();
	}
	
	/* ϥɥ򥭥㥹 */
	self = (C_PROCESS *)hProcess;
	
	if ( self->pEnv != NULL )
	{
		pszValue = Assoc_Get(self->pEnv, pszKey);
	}
	
	if ( pszValue == NULL )
	{
		if ( (hParent = Process_GetParentProcess(hProcess)) != HANDLE_NULL )
		{
			pszValue = Process_GetEnvString(hParent, hProcess);
		}
	}
	
	return pszValue;
}



/* end of file */
