/** 
 *  Hyper Operating System  Application Framework
 *
 * @file  process.c
 * @brief %jp{ץ֥}
 *
 * Copyright (C) 2006-2007 by Project HOS
 * http://sourceforge.jp/projects/hos/
 */



#include <string.h>
#include "process_local.h"


/** ¹Ի֤μ */	
unsigned long Process_GetExecutionTime(HANDLE hProcess, unsigned long *pulNanosecond)
{
	C_PROCESS		*self;
	SYSTIM_CPUTIME	CpuTime;
	
	/* ɥּ */
	if ( (long)hProcess == (-1) )
	{
		CpuTime = SysPrc_GetExecTime(SYSPRC_HANDLE_NULL);
		*pulNanosecond = SysTim_CpuTimeToNanosecond(CpuTime);	
		return SysTim_CpuTimeToSecond(CpuTime);
	}
	
	/* ̵꤬иߤΥץȤ */
	if ( hProcess == HANDLE_NULL )
	{
		hProcess = Process_GetCurrentHandle();
	}
	
	/* ϥɥ򥭥㥹 */
	self = (C_PROCESS *)hProcess;
	
	CpuTime = SysPrc_GetExecTime(self->hPrc);
	
	/* ʥñ̤Ǽ */
	if ( pulNanosecond != NULL )
	{
		*pulNanosecond = SysTim_CpuTimeToNanosecond(CpuTime);
	}
	
	return SysTim_CpuTimeToSecond(CpuTime);
}


/* end of file */
